/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryTableModel;

public class PatientHistoryTableModel
extends AbstractPatientHistoryTableModel {
    public PatientHistoryTableModel(LayoutContext context) {
        this(context, 100);
    }

    public PatientHistoryTableModel(LayoutContext context, int cacheSize) {
        super("act.patientClinicalEvent", context, cacheSize);
    }

    @Override
    protected Component getType(IMObjectBean bean) {
        Component result = bean.isA(new String[]{"act.patientClinicalProblem"}) ? this.getHyperlinkedType(bean) : super.getType(bean);
        return result;
    }

    @Override
    protected String getTypeName(IMObjectBean bean) {
        String result = super.getTypeName(bean);
        if (bean.isA(new String[]{"act.patientClinicalProblem"}) && this.isOngoingProblem(bean)) {
            result = Messages.format((String)"patient.record.summary.ongoingProblem", (Object[])new Object[]{result});
        }
        return result;
    }

    @Override
    protected Component formatParent(IMObjectBean bean) {
        Label result;
        String date = this.formatDateRange(bean);
        String text = this.formatEventText(bean);
        Label summary = LabelFactory.create(null, (String)"bold");
        summary.setText(Messages.format((String)"patient.record.summary.datedTitle", (Object[])new Object[]{date, text}));
        String detail = this.getText((Act)bean.getObject(Act.class), false);
        if (detail != null) {
            Label detailLabel = this.getTextDetail(detail);
            Row padding = RowFactory.create((String)"Inset", (Component[])new Component[]{new Label("")});
            Component dateSpacer = this.getDateSpacer();
            result = new Column();
            result.add((Component)summary);
            result.add((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{padding, dateSpacer, detailLabel}));
        } else {
            result = summary;
        }
        return result;
    }

    @Override
    protected Component formatItem(IMObjectBean bean) {
        Component detail = bean.isA(new String[]{"act.customerAccountInvoiceItem"}) ? this.getInvoiceItemDetail(bean) : (bean.isA(new String[]{"act.patientClinicalProblem"}) ? this.getProblemDetail(bean) : super.formatItem(bean));
        return detail;
    }

    @Override
    protected Component getMedicationDetail(IMObjectBean bean, boolean showBatches) {
        String text = this.getText((Act)bean.getObject(Act.class), true);
        List refs = bean.getSourceRefs("invoiceItem");
        if (!refs.isEmpty()) {
            ArchetypeQuery query = new ArchetypeQuery((Reference)refs.get(0));
            query.getArchetypeConstraint().setAlias("act");
            query.add((IConstraint)new NodeSelectConstraint("total"));
            query.setMaxResults(1);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator((IArchetypeQuery)query);
            if (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                text = Messages.format((String)"patient.record.summary.medication", (Object[])new Object[]{text, NumberFormatter.formatCurrency((Number)set.getBigDecimal("act.total"))});
            }
        }
        Label component = this.getTextDetail(text);
        if (showBatches) {
            component = this.addBatch(bean, (Component)component);
        }
        return component;
    }

    private Component getInvoiceItemDetail(IMObjectBean bean) {
        String name = this.getName(bean.getTargetRef("product"));
        FinancialAct act = (FinancialAct)bean.getObject(FinancialAct.class);
        String text = Messages.format((String)"patient.record.summary.invoiceitem", (Object[])new Object[]{name, act.getQuantity(), NumberFormatter.formatCurrency((Number)act.getTotal())});
        return this.getTextDetail(text);
    }

    private Component getProblemDetail(IMObjectBean bean) {
        Act act = (Act)bean.getObject(Act.class);
        Label result = this.getTextDetail(act);
        String presentingComplaint = LookupNameHelper.getName((IMObject)act, (String)"presentingComplaint");
        if (presentingComplaint != null) {
            Label label = LabelFactory.create();
            label.setText(Messages.format((String)"patient.record.summary.presentingComplaint", (Object[])new Object[]{presentingComplaint}));
            result = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{result, label});
        }
        return result;
    }

    private boolean isOngoingProblem(IMObjectBean bean) {
        Act event;
        List eventRefs = bean.getSourceRefs("events");
        if (eventRefs.size() > 1 && (event = this.getParent((Act)bean.getObject(Act.class))) != null) {
            eventRefs.remove(event.getObjectReference());
            return !this.isEarliestEvent(event, eventRefs);
        }
        return false;
    }

    private boolean isEarliestEvent(Act event, List<Reference> references) {
        boolean result = false;
        ArrayList<Long> dates = new ArrayList<Long>();
        for (Act object : this.getObjects()) {
            if (!object.isA("act.patientClinicalEvent") || !references.remove(object.getObjectReference())) continue;
            dates.add(object.getActivityStartTime().getTime());
        }
        if (references.isEmpty()) {
            Collections.sort(dates);
            result = event.getActivityStartTime().getTime() < (Long)dates.get(0);
        } else {
            Object[] ids = new Object[references.size()];
            for (int j = 0; j < references.size(); ++j) {
                ids[j] = references.get(j).getId();
            }
            ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)Constraints.shortName((String)"event", (String)"act.patientClinicalEvent"));
            query.add((IConstraint)Constraints.sort((String)"startTime"));
            query.add((IConstraint)new NodeSelectConstraint("event.startTime"));
            query.add((IConstraint)Constraints.in((String)"id", (Object[])ids));
            query.setMaxResults(1);
            ObjectSetQueryIterator iterator = new ObjectSetQueryIterator((IArchetypeQuery)query);
            if (iterator.hasNext()) {
                ObjectSet set = (ObjectSet)iterator.next();
                if (DateRules.compareTo((Date)event.getActivityStartTime(), (Date)set.getDate("event.startTime")) < 0) {
                    result = true;
                }
            }
        }
        return result;
    }
}

