/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.workspace.patient.history.AbstractPatientHistoryFilter;

public class PatientHistoryFilter
extends AbstractPatientHistoryFilter {
    private final List<String> archetypes;
    private final boolean invoice;
    private final Predicate<Act> search;
    private final ArchetypeService service;

    public PatientHistoryFilter(String[] archetypes, ArchetypeService service) {
        this(archetypes, true, service);
    }

    public PatientHistoryFilter(String[] archetypes, boolean sortAscending, ArchetypeService service) {
        this(archetypes, null, sortAscending, service);
    }

    public PatientHistoryFilter(String[] archetypes, Predicate<Act> search, boolean sortAscending, ArchetypeService service) {
        this(archetypes, null, search, sortAscending, service);
    }

    public PatientHistoryFilter(String[] archetypes, List<Act> communications, Predicate<Act> search, boolean sortAscending, ArchetypeService service) {
        super("act.patientClinicalEvent", communications);
        this.archetypes = new ArrayList<String>(Arrays.asList(archetypes));
        this.search = search;
        this.invoice = this.archetypes.remove("act.customerAccountInvoiceItem");
        this.service = service;
        this.setSortItemsAscending(sortAscending);
    }

    public Comparator<Act> getComparator(Act act) {
        if (act.isA(new String[]{"act.patientMedication", "act.patientClinicalNote"})) {
            return super.getComparator(true);
        }
        return super.getComparator(act);
    }

    protected List<Act> filter(Act parent, List<Act> children, Map<Reference, Act> acts) {
        List<Act> result;
        if (this.invoice && parent.isA("act.patientClinicalEvent")) {
            children = this.filterInvoiceItems(parent, children);
        }
        if (this.search == null) {
            result = children;
        } else {
            result = new ArrayList<Act>();
            for (Act act : children) {
                if (this.search.test(act)) {
                    result.add(act);
                    continue;
                }
                if (!this.supportsVersions(act)) continue;
                boolean add = false;
                for (Act child : this.getChildren(act, acts)) {
                    if (!this.search.test(child)) continue;
                    add = true;
                    break;
                }
                if (!add) continue;
                result.add(act);
            }
        }
        return result;
    }

    protected boolean include(Act child, Act parent, Act root) {
        IMObjectBean bean;
        Reference event;
        boolean result = true;
        if (parent.isA("act.patientClinicalProblem") && (event = (bean = this.service.getBean((IMObject)child)).getSourceRef("event")) != null && event.getId() != root.getId()) {
            result = false;
        }
        return result;
    }

    protected Collection<ActRelationship> getRelationships(Act act) {
        String[] acts = this.archetypes.toArray(new String[0]);
        return this.getRelationships(act.getSourceActRelationships(), PatientHistoryFilter.createIsA((String[])acts, (boolean)true));
    }

    private boolean supportsVersions(Act act) {
        return act instanceof DocumentAct && act.isA(new String[]{"act.patientInvestigation", "act.patientDocumentAttachment", "act.patientDocumentLetter", "act.patientDocumentImage"});
    }

    private List<Act> filterInvoiceItems(Act event, List<Act> children) {
        ArrayList<Act> result = new ArrayList<Act>(children);
        IMObjectBean bean = this.service.getBean((IMObject)event);
        List chargeItemRefs = bean.getTargetRefs("chargeItems");
        if (!chargeItemRefs.isEmpty()) {
            for (int i = 0; i < children.size() && !chargeItemRefs.isEmpty(); ++i) {
                IMObjectBean medication;
                List chargeItem;
                Act act = children.get(i);
                if (!act.isA("act.patientMedication") || (chargeItem = (medication = this.service.getBean((IMObject)act)).getSourceRefs("invoiceItem")).isEmpty()) continue;
                chargeItemRefs.remove(chargeItem.get(0));
            }
            List chargeItems = ActHelper.getActs((Collection)chargeItemRefs);
            result.addAll(chargeItems);
        }
        return result;
    }
}

