/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient.history;

import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.act.ActHierarchyFilter;

public class AbstractPatientHistoryFilter
extends ActHierarchyFilter<Act> {
    private final String primaryArchetype;
    private final List<Act> communications;

    public AbstractPatientHistoryFilter(String primaryArchetype, String[] archetypes, List<Act> communications) {
        super(archetypes, true);
        this.primaryArchetype = primaryArchetype;
        this.communications = communications;
    }

    public AbstractPatientHistoryFilter(String archetype, List<Act> communications) {
        this.primaryArchetype = archetype;
        this.communications = communications;
    }

    protected Set<Act> getChildren(Act act, Map<Reference, Act> acts) {
        Set children = super.getChildren(act, acts);
        if (this.communications != null && !this.communications.isEmpty() && act.isA(this.primaryArchetype)) {
            ListIterator<Act> iterator = this.communications.listIterator();
            Date startTime = act.getActivityStartTime();
            Date endTime = act.getActivityEndTime();
            while (iterator.hasNext()) {
                Act communication = iterator.next();
                if (!DateRules.between((Date)communication.getActivityStartTime(), (Date)startTime, (Date)endTime)) continue;
                children.add(communication);
                iterator.remove();
            }
        }
        return children;
    }
}

