/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientContext;
import org.openvpms.web.workspace.patient.summary.PatientSummary;

public class CustomerPatientSummary {
    private final PatientRules rules = (PatientRules)ServiceHelper.getBean(PatientRules.class);
    private final Context context;
    private final HelpContext help;
    private final Preferences preferences;
    private static final String PATIENT = "patient";
    private static final String CUSTOMER = "customer";

    public CustomerPatientSummary(Context context, HelpContext help, Preferences preferences) {
        this.context = context;
        this.help = help;
        this.preferences = preferences;
    }

    public Component getSummary(Party patient) {
        Component result = null;
        if (patient != null) {
            Party customer = this.rules.getOwner(patient);
            result = this.getSummary(customer, patient);
        }
        return result;
    }

    public Component getSummary(Act act) {
        Component result = null;
        if (act != null) {
            Party patient;
            IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
            Party party = patient = bean.hasNode(PATIENT) ? (Party)bean.getTarget(PATIENT, Party.class) : null;
            Party customer = bean.hasNode(CUSTOMER) ? (Party)bean.getTarget(CUSTOMER, Party.class) : (patient != null ? this.rules.getOwner(patient, act.getActivityStartTime(), false) : null);
            result = this.getSummary(customer, patient);
        }
        return result;
    }

    public HelpContext getHelpContext() {
        return this.help;
    }

    protected Context getContext() {
        return this.context;
    }

    protected Preferences getPreferences() {
        return this.preferences;
    }

    protected Component getSummary(Party customer, Party patient) {
        Component patientSummary;
        Column result = null;
        CustomerPatientContext local = new CustomerPatientContext(this.context);
        local.setCustomer(customer);
        local.setPatient(patient);
        Component customerSummary = customer != null ? this.getCustomerSummary(customer, (Context)local) : null;
        Component component = patientSummary = patient != null ? this.getPatientSummary(patient, (Context)local) : null;
        if (customerSummary != null || patientSummary != null) {
            result = ColumnFactory.create((String)"CellSpacing");
            if (customerSummary != null) {
                result.add(customerSummary);
            }
            if (patientSummary != null) {
                result.add(patientSummary);
            }
        }
        return result;
    }

    protected Component getCustomerSummary(Party customer, Context context) {
        CustomerSummary summary = new CustomerSummary(context, this.help, this.preferences);
        return summary.getSummary(customer);
    }

    protected Component getPatientSummary(Party patient, Context context) {
        PatientSummary summary = new PatientSummary(context, this.help, this.preferences, (ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        return summary.getSummary(patient);
    }
}

