/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.patient;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.list.AbstractListComponent;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.collections4.ComparatorUtils;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.list.BoldListCell;
import org.openvpms.web.component.im.list.LookupListCellRenderer;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.BoundLookupField;
import org.openvpms.web.component.im.lookup.DefaultLookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.resource.i18n.Messages;

public class BreedEditor
extends DefaultLookupPropertyEditor {
    private static final LookupListCellRenderer RENDERER = new BreedLookupListCellRenderer();

    public BreedEditor(Property property, IMObject parent) {
        super(property, BreedEditor.create(property, parent));
    }

    public boolean isNewBreed() {
        LookupField field = this.getComponent();
        BreedLookupListModel model = (BreedLookupListModel)field.getModel();
        return model.isNewBreed(field.getSelectedIndex());
    }

    public void selectNewBreed() {
        LookupField field = this.getComponent();
        BreedLookupListModel model = (BreedLookupListModel)field.getModel();
        field.setSelectedIndex(model.getNewBreedIndex());
    }

    public LookupField getComponent() {
        return (LookupField)super.getComponent();
    }

    private static LookupField create(Property breed, IMObject parent) {
        NodeLookupQuery query = new NodeLookupQuery(parent, breed);
        BreedLookupListModel model = new BreedLookupListModel((LookupQuery)query, !breed.isRequired());
        BoundLookupField field = new BoundLookupField(breed, (LookupListModel)model);
        LookupFieldFactory.setDefaultStyle((Component)field);
        field.setCellRenderer((ListCellRenderer)RENDERER);
        return field;
    }

    private static class BreedLookupListCellRenderer
    extends LookupListCellRenderer {
        static final String NEW_BREED = Messages.get((String)"patient.newbreed");

        private BreedLookupListCellRenderer() {
        }

        public Object getListCellRendererComponent(Component list, Object value, int index) {
            AbstractListComponent component = (AbstractListComponent)list;
            ListModel model = component.getModel();
            if (model instanceof BreedLookupListModel && ((BreedLookupListModel)model).isNewBreed(index)) {
                return new BoldListCell(NEW_BREED);
            }
            return super.getListCellRendererComponent(list, value, index);
        }
    }

    private static class BreedLookupListModel
    extends LookupListModel {
        private int newBreedIndex;
        private static final Comparator<String> COMPARATOR = ComparatorUtils.nullLowComparator((Comparator)ComparatorUtils.naturalComparator());

        public BreedLookupListModel(LookupQuery source, boolean none) {
            super(source, false, none);
        }

        public boolean isNewBreed(int index) {
            return index == this.newBreedIndex;
        }

        public int getNewBreedIndex() {
            return this.newBreedIndex;
        }

        protected void initObjects(List<? extends org.openvpms.component.model.lookup.Lookup> objects) {
            super.initObjects(objects);
            Lookup newBreed = new Lookup(null, null, BreedLookupListCellRenderer.NEW_BREED);
            List lookups = this.getObjects();
            this.newBreedIndex = Collections.binarySearch(lookups, newBreed, (o1, o2) -> {
                String name1 = o1 != null ? o1.getName() : null;
                String name2 = o2 != null ? o2.getName() : null;
                return COMPARATOR.compare(name1, name2);
            });
            if (this.newBreedIndex < 0) {
                this.newBreedIndex = -this.newBreedIndex - 1;
                lookups.add(this.newBreedIndex, null);
            }
        }
    }
}

