/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.Iterator;
import java.util.List;
import org.openvpms.archetype.rules.act.ActStatusHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.edit.payment.PaymentItemEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutableProperty;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.payment.TransactionPaymentLayoutStrategy;

public abstract class TransactionPaymentItemEditor
extends PaymentItemEditor {
    private boolean hasTransaction;
    private boolean complete;
    private static final String TRANSACTIONS = "transactions";

    public TransactionPaymentItemEditor(FinancialAct act, FinancialAct parent, LayoutContext context) {
        super(act, parent, context);
    }

    public boolean requiresTransaction() {
        return !this.isComplete();
    }

    public void performTransaction(Runnable listener) {
        DefaultValidator validator = new DefaultValidator();
        if (this.validate((Validator)validator)) {
            TransactionState state = this.getTransactionState();
            if (state != null) {
                this.performTransaction(state, listener);
            } else {
                this.refreshLayout();
                listener.run();
            }
        } else {
            ValidationHelper.showError((Validator)validator);
        }
    }

    public boolean canDelete() {
        return this.getDeletable().canDelete();
    }

    public boolean canCancelTransaction() {
        return false;
    }

    public void cancelTransaction() {
        throw new IllegalStateException("Transaction cancellation not supported");
    }

    public Deletable getDeletable() {
        FinancialAct act;
        Deletable result = Deletable.yes();
        Iterator<FinancialAct> iterator = this.getTransactions().iterator();
        while (iterator.hasNext() && (result = this.getDeletable(act = iterator.next())).canDelete()) {
        }
        return result;
    }

    protected abstract String getTransactionDisplayName();

    protected abstract void performTransaction(TransactionState var1, Runnable var2);

    protected abstract Deletable getDeletable(FinancialAct var1);

    protected abstract boolean isNewTransactionRequired(Act var1);

    protected abstract boolean isComplete(FinancialAct var1);

    protected boolean isComplete() {
        return this.complete;
    }

    protected boolean hasTransaction() {
        return this.hasTransaction;
    }

    protected void refreshLayout() {
        this.updateTransactionStatus();
        this.onLayout();
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateStatus(validator);
    }

    protected List<FinancialAct> getTransactions() {
        return this.getBean((IMObject)this.getObject()).getTargets(TRANSACTIONS, FinancialAct.class, Policies.orderBySequence());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new TransactionPaymentLayoutStrategy();
    }

    protected void addTransaction(FinancialAct act, int sequence) {
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        SequencedRelationship relationship = (SequencedRelationship)bean.addTarget(TRANSACTIONS, (IMObject)act, "transaction");
        relationship.setSequence(sequence);
        bean.save(new IMObject[]{act});
    }

    protected void updateTransactionStatus() {
        Act parent = (Act)this.getParent();
        if (ActStatusHelper.isPosted((Act)parent, (ArchetypeService)this.getService())) {
            this.updateTransactionStatus(null, true);
        } else {
            FinancialAct transaction = this.getLastTransaction();
            if (transaction != null) {
                boolean complete = this.isComplete(transaction);
                this.updateTransactionStatus(transaction, complete);
            } else {
                this.updateTransactionStatus(null, false);
            }
        }
    }

    protected boolean updateTransactionStatus(FinancialAct transaction, boolean complete) {
        boolean changed = this.complete != complete;
        this.complete = complete;
        this.hasTransaction = transaction != null;
        return changed |= this.updateReadOnly("amount", this.markPropertiesReadOnly());
    }

    protected boolean validateStatus(Validator validator) {
        boolean result;
        Act parent = (Act)this.getParent();
        if ("POSTED".equals(parent.getStatus()) && this.requiresTransaction()) {
            validator.add((Modifiable)this, Messages.format((String)"customer.payment.postedWithOutstandingTransaction", (Object[])new Object[]{this.getDisplayName((IMObject)parent), this.getTransactionDisplayName()}));
            result = false;
        } else {
            result = true;
        }
        return result;
    }

    protected FinancialAct getLastTransaction() {
        TransactionState lastTransaction = this.getLastTransaction(this.getBean((IMObject)this.getObject()));
        return lastTransaction != null ? lastTransaction.getAct() : null;
    }

    protected boolean updateReadOnly(String name, boolean readOnly) {
        boolean changed = false;
        MutableProperty property = (MutableProperty)this.getProperty(name);
        if (property.isReadOnly() != readOnly && !property.isHidden()) {
            changed = property.setReadOnly(readOnly);
        }
        return changed;
    }

    protected boolean markPropertiesReadOnly() {
        return this.isComplete();
    }

    private TransactionState getTransactionState() {
        TransactionState result = null;
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        TransactionState last = this.getLastTransaction(bean);
        int sequence = 0;
        if (last != null) {
            FinancialAct transaction = last.getAct();
            sequence = last.getSequence();
            if (this.isNewTransactionRequired((Act)transaction)) {
                result = new TransactionState(null, ++sequence);
            } else if (!this.isComplete(transaction)) {
                result = last;
            }
        } else {
            result = new TransactionState(null, ++sequence);
        }
        return result;
    }

    private TransactionState getLastTransaction(IMObjectBean bean) {
        int sequence = 0;
        Reference last = null;
        for (SequencedRelationship relationship : bean.getValues(TRANSACTIONS, SequencedRelationship.class)) {
            if (relationship.getSequence() < sequence) continue;
            last = relationship.getTarget();
            sequence = relationship.getSequence();
        }
        FinancialAct transaction = null;
        if (last != null) {
            transaction = (FinancialAct)bean.getObject(last, FinancialAct.class);
        }
        return transaction != null ? new TransactionState(transaction, sequence) : null;
    }

    protected static class TransactionState {
        private final FinancialAct act;
        private final int sequence;

        public TransactionState(FinancialAct act, int sequence) {
            this.act = act;
            this.sequence = sequence;
        }

        public FinancialAct getAct() {
            return this.act;
        }

        public int getSequence() {
            return this.sequence;
        }
    }
}

