/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.DefaultActQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.customer.CustomerActWorkspace;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.account.CustomerAccountActTableModel;
import org.openvpms.web.workspace.customer.payment.PaymentCRUDWindow;

public class PaymentWorkspace
extends CustomerActWorkspace<FinancialAct> {
    private static final String[] CUSTOMER_ARCHETYPES = new String[]{"party.customerperson", "party.organisationOTC"};
    private static final String[] PAYMENT_ARCHETYPES = new String[]{"act.customerAccountPayment", "act.customerAccountRefund"};

    public PaymentWorkspace(Context context, Preferences preferences) {
        super("customer.payment", context, preferences);
        this.setArchetypes(Party.class, CUSTOMER_ARCHETYPES);
        this.setChildArchetypes(FinancialAct.class, PAYMENT_ARCHETYPES);
    }

    @Override
    protected CustomerMailContext createMailContext(Context context, HelpContext help) {
        return new BillingCustomerMailContext(context, help);
    }

    protected CRUDWindow<FinancialAct> createCRUDWindow() {
        return new PaymentCRUDWindow((Archetypes<FinancialAct>)this.getChildArchetypes(), this.getContext(), this.getHelpContext());
    }

    protected Query<FinancialAct> createQuery() {
        String[] statuses = new String[]{"IN_PROGRESS", "ON_HOLD"};
        return new DefaultActQuery((Entity)this.getObject(), "customer", "participation.customer", PAYMENT_ARCHETYPES, statuses);
    }

    protected void onSaved(FinancialAct object, boolean isNew) {
        super.onSaved((IMObject)object, isNew);
        if ("POSTED".equals(object.getStatus())) {
            this.onBrowserSelected(null);
        }
    }

    protected Browser<FinancialAct> createBrowser(Query<FinancialAct> query) {
        CustomerAccountActTableModel model = new CustomerAccountActTableModel(true, false);
        return BrowserFactory.create(query, null, model, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }
}

