/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.Objects;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.lookup.DefaultLookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;

public class PaymentStatus {
    private final Property status;
    private final boolean readOnly;
    private final SimpleProperty view;
    private final LookupPropertyEditor editor;
    private final ModifiableListener statusListener;
    private boolean postOnCompletion = false;

    public PaymentStatus(Property status, FinancialAct parent) {
        this.status = status;
        this.readOnly = this.isPosted() && !parent.isNew();
        this.statusListener = modifiable -> this.onPropertyModified();
        if (!this.readOnly) {
            this.view = new SimpleProperty(status.getName(), status.getValue(), status.getType(), status.getDisplayName());
            NodeLookupQuery query = new NodeLookupQuery((IMObject)parent, status);
            LookupField field = LookupFieldFactory.create((Property)this.view, (LookupQuery)query);
            this.editor = new DefaultLookupPropertyEditor((Property)this.view, field);
            this.status.addModifiableListener(this.statusListener);
            this.view.addModifiableListener(modifiable -> this.onViewModified());
        } else {
            this.editor = null;
            this.view = null;
        }
    }

    public boolean isPosted() {
        return "POSTED".equals(this.status.getString());
    }

    public void makeSaveable() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot update status of POSTED act");
        }
        this.postOnCompletion = false;
        this.changeStatus("IN_PROGRESS");
    }

    public void makeSaveableAndPostOnCompletion() {
        if (this.readOnly) {
            throw new IllegalStateException("Cannot update status of POSTED act");
        }
        if (this.isPosted()) {
            this.postOnCompletion = true;
            this.changeStatus("IN_PROGRESS");
        }
    }

    public PropertyEditor getEditor() {
        return this.editor;
    }

    public boolean postOnCompletion() {
        return this.postOnCompletion && !this.isPosted();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void changeStatus(String newStatus) {
        try {
            this.status.removeModifiableListener(this.statusListener);
            this.status.setValue((Object)newStatus);
        }
        finally {
            this.status.addModifiableListener(this.statusListener);
        }
    }

    private void onPropertyModified() {
        String value = this.status.getString();
        if (this.readOnly) {
            if (!"POSTED".equals(value)) {
                this.changeStatus("POSTED");
                throw new IllegalStateException("Cannot update status of POSTED act");
            }
        } else if (!Objects.equals(value, this.view.getString())) {
            this.view.setValue((Object)value);
        }
    }

    private void onViewModified() {
        this.postOnCompletion = false;
        String value = this.view.getString();
        if (!Objects.equals(value, this.status.getString())) {
            this.changeStatus(value);
        }
    }
}

