/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.payment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SplitPane;
import org.openvpms.component.business.service.security.RunAs;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.user.User;
import org.openvpms.eftpos.service.ManagedTransactionDisplay;
import org.openvpms.eftpos.service.Prompt;
import org.openvpms.eftpos.transaction.Transaction;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.print.DefaultBatchPrinter;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.echo.util.PeriodicBackgroundTask;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.payment.EFTHelper;

public class EFTPaymentDialog
extends ModalDialog {
    private final IMObjectBean transaction;
    private final ManagedTransactionDisplay display;
    private final User user;
    private final Context context;
    private final Row terminalButtons;
    private final boolean print;
    private final Label content;
    private final PeriodicBackgroundTask task;
    private final Set<Long> printed = new HashSet<Long>();
    private final Semaphore waiter = new Semaphore(1);
    private int printJobs = 0;
    private static final String PRINT_MERCHANT_RECEIPT_ID = "button.printMerchantReceipt";
    private static final String[] BUTTONS = new String[]{"ok"};
    private static final int POLL_INTERVAL = 6;

    public EFTPaymentDialog(Act transaction, ManagedTransactionDisplay display, User user, Context context, HelpContext help) {
        super(EFTHelper.getDialogTitle((IMObject)transaction), BUTTONS, help);
        this.transaction = ServiceHelper.getArchetypeService().getBean((IMObject)transaction);
        this.display = display;
        this.user = user;
        this.context = context;
        this.terminalButtons = RowFactory.create((String)"WideCellSpacing", (Component[])new Component[0]);
        this.content = LabelFactory.create((boolean)true, (boolean)true);
        this.print = !display.getTransaction().getTerminal().isReceiptPrinter();
        SplitPane container = SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{RowFactory.create((String)"InsetX.Large", (Component[])new Component[]{this.terminalButtons}), ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.content})});
        this.task = new PeriodicBackgroundTask(6, TimeUnit.SECONDS, (SessionMonitor)ServiceHelper.getBean(SessionMonitor.class), () -> ((ManagedTransactionDisplay)display).isComplete(), this::backgroundUpdateTransaction, () -> this.refresh(true));
        ButtonSet buttons = this.getButtons();
        buttons.setEnabled("ok", false);
        buttons.add(PRINT_MERCHANT_RECEIPT_ID, () -> this.printMerchantReceipts(true));
        buttons.setEnabled(PRINT_MERCHANT_RECEIPT_ID, false);
        this.getLayout().add((Component)container);
        this.resize("EFTPaymentDialog.size");
    }

    public void show() {
        super.show();
        this.task.start();
    }

    public void dispose() {
        this.task.dispose();
        super.dispose();
    }

    protected void doLayout() {
        this.refresh(false);
    }

    protected void doCancel() {
        Transaction transaction = this.display.getTransaction();
        Transaction.Status status = transaction.getStatus();
        if (status == Transaction.Status.PENDING || status == Transaction.Status.IN_PROGRESS) {
            this.display.cancel();
        }
        super.doCancel();
    }

    protected void refresh(boolean printOutstanding) {
        this.terminalButtons.removeAll();
        try {
            boolean complete;
            if (this.print && printOutstanding) {
                this.printMerchantReceipts(false);
            }
            if ((complete = this.display.isComplete()) && this.canClose()) {
                this.close();
            } else {
                StringBuilder buffer = new StringBuilder();
                List messages = this.display.getMessages();
                for (String message : messages) {
                    if (buffer.length() > 0) {
                        buffer.append('\n');
                    }
                    buffer.append(message);
                }
                Prompt prompt = this.display.getPrompt();
                if (prompt != null) {
                    if (buffer.length() > 0) {
                        buffer.append('\n');
                    }
                    buffer.append(prompt.getMessage());
                    if (!complete) {
                        for (Prompt.Option option : prompt.getOptions()) {
                            Button button = ButtonFactory.text((String)option.getText(), () -> this.pressTerminalButton(prompt, option));
                            this.terminalButtons.add((Component)button);
                        }
                    }
                }
                this.content.setText(buffer.toString());
                if (complete) {
                    this.getButtons().setEnabled("ok", true);
                }
                if (this.hasMerchantReceipts()) {
                    this.getButtons().setEnabled(PRINT_MERCHANT_RECEIPT_ID, true);
                }
            }
        }
        catch (Throwable exception) {
            this.content.setText(ErrorFormatter.format((Throwable)exception));
        }
    }

    private boolean canClose() {
        return this.printJobs == 0 && this.display.getTransaction().getStatus() == Transaction.Status.APPROVED;
    }

    private void pressTerminalButton(Prompt prompt, Prompt.Option option) {
        try {
            prompt.send(option);
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.updateTransaction();
        this.refresh(true);
    }

    private void printMerchantReceipts(boolean all) {
        ArrayList<DocumentAct> toPrint = new ArrayList<DocumentAct>();
        for (Relationship relationship : this.getMerchantReceiptRelationships()) {
            long id = relationship.getTarget().getId();
            if (!all && this.printed.contains(id)) continue;
            this.printed.add(id);
            DocumentAct act = (DocumentAct)IMObjectHelper.getObject((Reference)relationship.getTarget());
            if (act == null || !all && act.isPrinted()) continue;
            toPrint.add(act);
        }
        if (!toPrint.isEmpty()) {
            ++this.printJobs;
            ReceiptPrinter printer = new ReceiptPrinter(toPrint){

                protected void completed() {
                    EFTPaymentDialog.this.printJobs--;
                }
            };
            printer.print();
        }
    }

    private boolean hasMerchantReceipts() {
        boolean result;
        boolean bl = result = !this.printed.isEmpty();
        if (!result) {
            List<Relationship> receipts = this.getMerchantReceiptRelationships();
            result = !receipts.isEmpty();
        }
        return result;
    }

    private List<Relationship> getMerchantReceiptRelationships() {
        return this.transaction.getValues("receipts", Relationship.class, Predicates.targetIsA((String[])new String[]{"act.EFTPOSReceiptMerchant"}));
    }

    private boolean backgroundUpdateTransaction() {
        return (Boolean)RunAs.call((User)this.user, this::updateTransaction);
    }

    private boolean updateTransaction() {
        boolean result = false;
        if (this.waiter.tryAcquire()) {
            try {
                result = this.display.update();
            }
            finally {
                this.waiter.release();
            }
        }
        return result;
    }

    private class ReceiptPrinter
    extends DefaultBatchPrinter<DocumentAct> {
        public ReceiptPrinter(List<DocumentAct> toPrint) {
            super(toPrint, EFTPaymentDialog.this.context, EFTPaymentDialog.this.getHelpContext());
        }

        protected DocumentTemplateLocator createDocumentTemplateLocator(DocumentAct object, Context context) {
            return new ContextDocumentTemplateLocator("act.EFTPOSReceiptCustomer", context);
        }
    }
}

