/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.order;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.finance.order.OrderRules;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.act.PagedActHierarchyTableModel;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.order.PendingOrderQuery;

public class PendingOrderBrowser
extends AbstractQueryBrowser<Act> {
    private static final String[] ITEM_SHORT_NAMES = new String[]{"act.customerOrderItemPharmacy", "act.customerReturnItemPharmacy"};

    public PendingOrderBrowser(PendingOrderQuery query, LayoutContext context) {
        super((Query)query, null, null, context);
    }

    public List<Act> getOrders() {
        PagedActHierarchyTableModel paged = (PagedActHierarchyTableModel)this.getTableModel();
        OrderTableModel model = (OrderTableModel)paged.getModel();
        return model.getOrders();
    }

    protected Component doQueryLayout() {
        return this.getQuery().getComponent();
    }

    protected IMTableModel<Act> createTableModel(LayoutContext context) {
        return new PagedActHierarchyTableModel((IMObjectTableModel)new OrderTableModel(context), ITEM_SHORT_NAMES);
    }

    private static class OrderTableModel
    extends DescriptorTableModel<Act> {
        private final OrderRules rules;
        private final Map<Reference, Boolean> selected = new HashMap<Reference, Boolean>();
        private int patientIndex;
        private int productIndex;
        private int quantityIndex;
        private int clinicianIndex;
        private int invoicedIndex;
        private int selectedIndex;

        public OrderTableModel(LayoutContext context) {
            super(PendingOrderQuery.SHORT_NAMES, context);
            this.rules = (OrderRules)ServiceHelper.getBean(OrderRules.class);
        }

        public List<Act> getOrders() {
            ArrayList<Act> result = new ArrayList<Act>();
            for (Map.Entry<Reference, Boolean> entry : this.selected.entrySet()) {
                IMObject object;
                if (entry.getValue() != null && !entry.getValue().booleanValue() || (object = IMObjectHelper.getObject((Reference)entry.getKey())) == null) continue;
                result.add((Act)object);
            }
            return result;
        }

        protected String[] getNodeNames() {
            return new String[]{"id", "status", "startTime", "clinician"};
        }

        protected Object getValue(Act object, TableColumn column, int row) {
            Object result = null;
            int index = column.getModelIndex();
            if (TypeHelper.isA((IMObject)object, (String[])ITEM_SHORT_NAMES)) {
                if (index == this.clinicianIndex || index == this.patientIndex || index == this.productIndex || index == this.quantityIndex) {
                    result = super.getValue((IMObject)object, column, row);
                } else if (index == this.invoicedIndex && (result = this.rules.getInvoicedQuantity(object)) != null) {
                    result = LabelFactory.create((Number)((Number)result), (CellLayoutData)new TableLayoutData());
                }
            } else if (index == this.selectedIndex) {
                result = this.getCheckBox(object);
            } else if (index != this.invoicedIndex) {
                result = super.getValue((IMObject)object, column, row);
            }
            return result;
        }

        protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
            List archetypes = DescriptorHelper.getArchetypeDescriptors((String[])ITEM_SHORT_NAMES, (ArchetypeService)ServiceHelper.getArchetypeService());
            TableColumnModel columns = super.createColumnModel(shortNames, context);
            DescriptorTableColumn clinician = this.getColumn(columns, "clinician");
            this.clinicianIndex = clinician != null ? clinician.getModelIndex() : -1;
            this.selectedIndex = this.getNextModelIndex(columns);
            columns.addColumn(new TableColumn(this.selectedIndex));
            columns.moveColumn(columns.getColumnCount() - 1, 0);
            this.patientIndex = this.selectedIndex + 1;
            this.productIndex = this.patientIndex + 1;
            this.quantityIndex = this.productIndex + 1;
            this.invoicedIndex = this.quantityIndex + 1;
            this.addColumn(archetypes, "patient", this.patientIndex, columns);
            this.addColumn(archetypes, "product", this.productIndex, columns);
            this.addColumn(archetypes, "quantity", this.quantityIndex, columns);
            columns.addColumn(OrderTableModel.createTableColumn((int)this.invoicedIndex, (String)"customer.order.invoiceqty"));
            return columns;
        }

        private nextapp.echo2.app.CheckBox getCheckBox(Act object) {
            final Reference reference = object.getObjectReference();
            Boolean value = this.selected.computeIfAbsent(reference, k -> Boolean.TRUE);
            CheckBox checkBox = CheckBoxFactory.create((boolean)value);
            checkBox.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener((nextapp.echo2.app.CheckBox)checkBox){
                final /* synthetic */ nextapp.echo2.app.CheckBox val$checkBox;
                {
                    this.val$checkBox = checkBox;
                }

                public void onAction(ActionEvent event) {
                    selected.put(reference, this.val$checkBox.isSelected());
                }
            });
            return checkBox;
        }
    }
}

