/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.DefaultIMObjectActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.info.CustomerMergeWorkflow;

public class InformationCRUDWindow
extends AbstractViewCRUDWindow<Party> {
    private static final String MERGE_ID = "merge";

    public InformationCRUDWindow(Archetypes<Party> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)DefaultIMObjectActions.getInstance(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        if (UserHelper.isAdmin((User)this.getContext().getUser())) {
            buttons.add(MERGE_ID, this::onMerge);
        }
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean enableForPerson = enable && TypeHelper.isA((IMObject)this.getObject(), (String)"party.customerperson");
        buttons.setEnabled(MERGE_ID, enableForPerson);
    }

    private void onMerge() {
        HelpContext help = this.getHelpContext().subtopic(MERGE_ID);
        CustomerMergeWorkflow workflow = new CustomerMergeWorkflow((Party)this.getObject(), help);
        workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                if (event.getType() == TaskEvent.Type.COMPLETED) {
                    InformationCRUDWindow.this.onRefresh(InformationCRUDWindow.this.getObject());
                }
            }
        });
        workflow.start();
    }
}

