/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.info;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public class CustomerLayoutStrategy
extends AbstractLayoutStrategy {
    public CustomerLayoutStrategy() {
        super(ArchetypeNodes.all().exclude(new String[]{"referredByCustomer"}));
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property property = properties.get("referral");
        ComponentState referral = this.createComponent(property, object, context);
        ComponentState customer = this.createComponent(properties.get("referredByCustomer"), object, context);
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{referral.getComponent(), customer.getComponent()});
        if (context.isEdit()) {
            property.addModifiableListener(modifiable -> this.updateReferral(property, customer));
        }
        this.updateReferral(property, customer);
        FocusGroup focus = new FocusGroup(property.getName());
        focus.add(referral.getComponent());
        if (customer.getFocusGroup() != null) {
            focus.add(customer.getFocusGroup());
        } else {
            focus.add(customer.getComponent());
        }
        this.addComponent(new ComponentState((Component)row, property, focus));
        return super.apply(object, properties, parent, context);
    }

    private void updateReferral(Property referral, ComponentState customer) {
        customer.getComponent().setVisible("CUSTOMER".equals(referral.getString()));
    }
}

