/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.estimate;

import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public class EstimateViewer
extends PopupDialog {
    private final List<Act> estimates;
    private final Context context;
    private PagedIMTable<Act> table;
    private Column column;
    private Component viewer;

    public EstimateViewer(List<Act> estimates, Context context, HelpContext help) {
        super(Messages.get((String)"estimates.title"), "EstimatesViewer", CLOSE, help);
        this.context = context;
        this.estimates = estimates;
        this.setModal(true);
    }

    protected void doLayout() {
        this.getLayout().add(this.getComponent());
    }

    private Component getComponent() {
        ListResultSet set = new ListResultSet(this.estimates, 20);
        DefaultDescriptorTableModel model = new DefaultDescriptorTableModel("act.customerEstimation", this.createLayoutContext(this.context, this.getHelpContext()), new String[0]);
        this.table = new PagedIMTable((IMTableModel)model, (ResultSet)set);
        this.table.getTable().setStyleName("EstimatesTableViewer");
        this.column = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.table.getComponent()})});
        if (this.estimates.size() == 1) {
            this.show(this.estimates.get(0));
        } else {
            this.table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    EstimateViewer.this.showSelected();
                }
            });
        }
        return this.column;
    }

    private void showSelected() {
        Act estimate = (Act)this.table.getSelected();
        this.show(estimate);
    }

    private void show(Act estimate) {
        if (estimate != null) {
            if (this.viewer != null) {
                this.column.remove(this.viewer);
            }
            DefaultLayoutContext layout = new DefaultLayoutContext(this.context, this.getHelpContext());
            this.viewer = new IMObjectViewer((IMObject)estimate, (LayoutContext)layout).getComponent();
            this.column.add(this.viewer);
        }
    }

    private LayoutContext createLayoutContext(Context context, HelpContext help) {
        DefaultLayoutContext result = new DefaultLayoutContext(context, help);
        result.setEdit(true);
        TableComponentFactory factory = new TableComponentFactory((LayoutContext)result);
        result.setComponentFactory((IMObjectComponentFactory)factory);
        return result;
    }
}

