/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.mail.DefaultMailer;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.communication.CommunicationHelper;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.springframework.mail.javamail.JavaMailSender;

public class LoggingMailer
implements Mailer {
    private final Mailer mailer;
    private final CommunicationLogger logger;

    public LoggingMailer(MailContext context, JavaMailSender sender, DocumentHandlers handlers, CommunicationLogger logger) {
        this.mailer = new DefaultMailer(context, sender, handlers);
        this.logger = logger;
    }

    public MailContext getContext() {
        return this.mailer.getContext();
    }

    public void setFrom(String from) {
        this.mailer.setFrom(from);
    }

    public String getFrom() {
        return this.mailer.getFrom();
    }

    public void setTo(String[] to) {
        this.mailer.setTo(to);
    }

    public String[] getTo() {
        return this.mailer.getTo();
    }

    public void setCc(String[] cc) {
        this.mailer.setCc(cc);
    }

    public String[] getCc() {
        return this.mailer.getCc();
    }

    public void setBcc(String[] bcc) {
        this.mailer.setBcc(bcc);
    }

    public String[] getBcc() {
        return this.mailer.getBcc();
    }

    public void setSubject(String subject) {
        this.mailer.setSubject(subject);
    }

    public String getSubject() {
        return this.mailer.getSubject();
    }

    public void setBody(String body) {
        this.mailer.setBody(body);
    }

    public String getBody() {
        return this.mailer.getBody();
    }

    public void addAttachment(Document document) {
        this.mailer.addAttachment(document);
    }

    public List<Document> getAttachments() {
        return this.mailer.getAttachments();
    }

    public void send() {
        this.mailer.send();
        if (this.getContext() instanceof CustomerMailContext) {
            CustomerMailContext context = (CustomerMailContext)this.getContext();
            this.log(context, this.mailer, this.logger);
        }
    }

    protected Mailer getMailer() {
        return this.mailer;
    }

    protected CommunicationLogger getLogger() {
        return this.logger;
    }

    protected void log(CustomerMailContext context, Mailer mailer, CommunicationLogger logger) {
        Party customer = context.getCustomer();
        Party location = context.getLocation();
        if (customer != null) {
            String attachments = CommunicationHelper.getAttachments(mailer.getAttachments());
            String reason = mailer.getAttachments().isEmpty() ? "AD_HOC_EMAIL" : "FORWARDED_DOCUMENT";
            logger.logEmail(customer, context.getPatient(), mailer.getFrom(), mailer.getTo(), mailer.getCc(), mailer.getBcc(), mailer.getSubject(), reason, mailer.getBody(), null, attachments, location);
        }
    }
}

