/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.workspace.customer.communication.CommunicationLayoutStrategy;

public class EmailCommunicationLayoutStrategy
extends CommunicationLayoutStrategy {
    public static final String FROM = "from";
    public static final String CC = "cc";
    public static final String BCC = "bcc";
    public static final String ATTACHMENTS = "attachments";

    public EmailCommunicationLayoutStrategy() {
        this(null, true);
    }

    public EmailCommunicationLayoutStrategy(Property message, boolean showPatient) {
        super(message, "contact.email", showPatient);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property attachments = properties.get(ATTACHMENTS);
        if (attachments != null) {
            this.addComponent(this.createMultiLineText(attachments, 2, 10, Styles.FULL_WIDTH, context));
        }
        return super.apply(object, properties, parent, context);
    }

    @Override
    protected void addContactViewers(PropertySet properties, IMObject object, LayoutContext context) {
        super.addContactViewers(properties, object, context);
        this.addContactViewer(properties.get(FROM), object, context, true);
        this.addContactViewer(properties.get(CC), object, context, true);
        this.addContactViewer(properties.get(BCC), object, context, true);
    }

    @Override
    protected void addContactEditors(IMObject object, PropertySet properties, Party customer, LayoutContext context) {
        super.addContactEditors(object, properties, customer, context);
        this.addFromEmailSelector(properties.get(FROM), object, context);
        this.addContactSelector(properties.get(CC), object, customer, context);
        this.addContactSelector(properties.get(BCC), object, customer, context);
    }

    @Override
    protected List<Property> getHeaderProperties(List<Property> properties) {
        return ArchetypeNodes.include(properties, (String[])new String[]{FROM, "address", CC, BCC, "description"});
    }

    @Override
    protected List<Property> excludeEmptyHeaderProperties(List<Property> properties) {
        return this.excludeIfEmpty(properties, FROM, CC, BCC, "description");
    }

    @Override
    protected List<Property> getTextProperties(List<Property> properties, Property message) {
        List<Property> result = super.getTextProperties(properties, message);
        result.addAll(ArchetypeNodes.include(properties, (String[])new String[]{ATTACHMENTS}));
        return result;
    }

    @Override
    protected List<Property> excludeEmptyTextProperties(List<Property> properties) {
        return this.excludeIfEmpty(properties, "note", ATTACHMENTS);
    }

    protected void addFromEmailSelector(Property property, IMObject object, LayoutContext context) {
        List<Contact> contacts = this.getContacts(context.getContext().getPractice());
        contacts.addAll(this.getContacts(context.getContext().getLocation()));
        this.addContactSelector(property, object, contacts, context);
    }
}

