/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.ArrayList;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.lookup.ArchetypeLookupQuery;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.LocalSortResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.workspace.alert.AlertPriorityTransformer;

public class CustomerAlertQuery
extends DateRangeActQuery<Act> {
    private final LookupField alertTypes;
    private final boolean activeNow;
    private String alertType;
    private static final ActStatuses STATUSES = new ActStatuses("act.customerAlert");
    private static final SortConstraint[] DEFAULT_SORT = new SortConstraint[]{new VirtualNodeSortConstraint("alertType.priority", true, AlertPriorityTransformer.INSTANCE), new NodeSortConstraint("id")};

    public CustomerAlertQuery(Party customer) {
        this(customer, false);
    }

    public CustomerAlertQuery(Party customer, boolean activeNow) {
        super((Entity)customer, "customer", "participation.customer", new String[]{"act.customerAlert"}, STATUSES, Act.class);
        this.setDefaultSortConstraint(DEFAULT_SORT);
        ArchetypeLookupQuery source = new ArchetypeLookupQuery("lookup.customerAlertType");
        this.alertTypes = LookupFieldFactory.create((LookupQuery)source, (boolean)true);
        this.alertTypes.setSelected((String)null);
        this.alertTypes.addPropertyChangeListener(evt -> this.onAlertTypeChanged());
        this.alertTypes.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                CustomerAlertQuery.this.onQuery();
            }
        });
        this.activeNow = activeNow;
    }

    public ResultSet<Act> query(SortConstraint[] sort) {
        ResultSet<Act> result = super.query(sort);
        if (this.alertType != null) {
            result = this.filterOnAlertType(result, sort);
        }
        return result;
    }

    public void setAlertType(String alertType) {
        this.alertType = alertType;
    }

    protected void doLayout(Component container) {
        container.add((Component)LabelFactory.create((String)"customer.alert.type"));
        container.add((Component)this.alertTypes);
        this.getFocusGroup().add((Component)this.alertTypes);
        super.doLayout(container);
        FocusHelper.setFocus((Component)this.alertTypes);
    }

    protected ResultSet<Act> createResultSet(SortConstraint[] sort) {
        ResultSet set;
        if (this.activeNow) {
            IConstraint dateRangeConstraint = QueryHelper.createDateRangeConstraint((Date)new Date());
            set = new ActResultSet(this.getArchetypeConstraint(), new ParticipantConstraint[]{this.getParticipantConstraint()}, dateRangeConstraint, this.getStatuses(), this.excludeStatuses(), this.getConstraints(), this.getMaxResults(), null);
        } else {
            set = super.createResultSet(null);
        }
        LocalSortResultSet result = new LocalSortResultSet(set);
        result.sort(sort);
        return result;
    }

    private ResultSet<Act> filterOnAlertType(ResultSet<Act> set, SortConstraint[] sort) {
        ArrayList<Act> matches = new ArrayList<Act>();
        while (set.hasNext()) {
            IPage page = (IPage)set.next();
            for (Act act : page.getResults()) {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
                if (!this.alertType.equals(bean.getValue("alertType"))) continue;
                matches.add(act);
            }
        }
        IMObjectListResultSet result = new IMObjectListResultSet(matches, this.getMaxResults());
        if (sort != null) {
            result.sort(sort);
        }
        return result;
    }

    private void onAlertTypeChanged() {
        this.setAlertType(this.alertTypes.getSelectedCode());
    }
}

