/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActQuery;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.TabbedBrowser;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.DefaultCRUDWindow;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.CustomerActWorkspace;
import org.openvpms.web.workspace.customer.communication.CommunicationCRUDWindow;
import org.openvpms.web.workspace.customer.communication.CommunicationQuery;
import org.openvpms.web.workspace.customer.communication.CommunicationTableModel;
import org.openvpms.web.workspace.customer.communication.CustomerAlertQuery;

public class CommunicationWorkspace
extends CustomerActWorkspace<Act> {
    private final Archetypes<Act> alertArchetypes;
    private static final String[] SHORT_NAMES = new String[]{"act.customerAlert", "act.customerCommunication*"};

    public CommunicationWorkspace(Context context, Preferences preferences) {
        super("customer.communication", context, preferences);
        this.setChildArchetypes(Act.class, SHORT_NAMES);
        this.alertArchetypes = Archetypes.create((String)"act.customerAlert", Act.class);
    }

    public boolean canUpdate(String shortName) {
        return super.canUpdate(shortName) || TypeHelper.matches((String)shortName, (String)"act.customerCommunication*");
    }

    @Override
    public void show() {
        super.show();
        Browser browser = this.getBrowser();
        if (browser != null) {
            BrowserState state = browser.getBrowserState();
            if (state != null && !state.isEmpty()) {
                browser.setBrowserState(state);
            } else {
                browser.query();
            }
        }
    }

    protected CRUDWindow<Act> createCRUDWindow() {
        return new CommunicationCRUDWindow(this.getContext(), this.getHelpContext());
    }

    protected ActQuery<Act> createQuery() {
        return new CommunicationQuery((Party)this.getObject(), (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    protected CommunicationBrowser createBrowser(Query<Act> query) {
        CustomerAlertQuery alertsQuery = new CustomerAlertQuery((Party)this.getObject());
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        CommunicationBrowser browser = new CommunicationBrowser(query, (Query<Act>)alertsQuery, (LayoutContext)context);
        browser.setListener(this::changeCRUDWindow);
        return browser;
    }

    protected Component createWorkspace() {
        return SplitPaneFactory.create((int)5, (String)"BrowserCRUDWorkspace.Layout", (Component[])new Component[]{this.getBrowser().getComponent(), this.getCRUDWindow().getComponent()});
    }

    private void changeCRUDWindow() {
        CommunicationBrowser browser = (CommunicationBrowser)this.getBrowser();
        CommunicationCRUDWindow window = browser.isAlertsBrowser() ? new DefaultCRUDWindow(this.alertArchetypes, this.getContext(), this.getHelpContext()) : new CommunicationCRUDWindow(this.getContext(), this.getHelpContext());
        Act selected = (Act)browser.getSelected();
        if (selected != null) {
            window.setObject((IMObject)selected);
        }
        this.setCRUDWindow((CRUDWindow)window);
        this.setWorkspace(this.createWorkspace());
    }

    private static class CommunicationBrowser
    extends TabbedBrowser<Act> {
        private final int alertsIndex;

        public CommunicationBrowser(Query<Act> communications, Query<Act> alerts, LayoutContext context) {
            this.addBrowser(Messages.get((String)"customer.communication.communications"), BrowserFactory.create(communications, null, (IMTableModel)new CommunicationTableModel(communications.getShortNames(), context), (LayoutContext)context));
            this.alertsIndex = this.addBrowser(Messages.get((String)"customer.communication.alerts"), BrowserFactory.create(alerts, (LayoutContext)context));
        }

        public boolean isAlertsBrowser() {
            return this.getSelectedBrowserIndex() == this.alertsIndex;
        }
    }
}

