/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.communication;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.text.TextComponent;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.AuditableIMObject;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.audit.AuditInfo;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.DocumentBackedTextProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.messaging.messages.AbstractMessageLayoutStrategy;

public abstract class AbstractCommunicationLayoutStrategy
extends AbstractMessageLayoutStrategy {
    public static final String CREATED_BY = "createdBy";
    public static final String ADDRESS = "address";
    public static final String DESCRIPTION = "description";
    public static final String LOCATION = "location";
    public static final String PATIENT = "patient";
    public static final String START_TIME = "startTime";
    public static final String MESSAGE = "message";
    public static final String NOTE = "note";
    public static final String DOCUMENT = "document";
    public static final String REASON = "reason";
    private final boolean showPatient;
    private final String createdTime;
    private Property messageProxy;

    public AbstractCommunicationLayoutStrategy(boolean showPatient, Property message, String createdTime) {
        this.showPatient = showPatient;
        this.messageProxy = message;
        this.createdTime = createdTime;
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        Property descriptionProperty;
        if (this.messageProxy == null) {
            Property message = properties.get(MESSAGE);
            this.messageProxy = properties.get(DOCUMENT) != null ? new DocumentBackedTextProperty((DocumentAct)object, message) : message;
        }
        if ((descriptionProperty = properties.get(DESCRIPTION)) != null) {
            ComponentState description = this.createComponent(descriptionProperty, object, context);
            if (description.getComponent() instanceof TextComponent) {
                ((TextComponent)description.getComponent()).setWidth(Styles.FULL_WIDTH);
            }
            this.addComponent(description);
        }
        this.addComponent(this.createMessage(this.messageProxy, context));
        Property note = properties.get(NOTE);
        if (note != null) {
            this.addComponent(this.createMultiLineText(note, 2, 10, Styles.FULL_WIDTH, context));
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentState createMessage(Property property, LayoutContext context) {
        return this.createMultiLineText(property, 10, 20, Styles.FULL_WIDTH, context);
    }

    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        ArchetypeDescriptor archetype = context.getArchetypeDescriptor(object);
        ArchetypeNodes nodes = this.getArchetypeNodes();
        NodeFilter filter = this.getNodeFilter(object, context);
        List simple = nodes.getSimpleNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List complex = nodes.getComplexNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List<Property> header = this.getHeaderProperties(simple);
        List patient = this.getPatientProperties(simple);
        List<Property> fields = ArchetypeNodes.exclude((List)simple, (String[])new String[]{this.createdTime, MESSAGE, NOTE});
        List<Property> text = this.getTextProperties(simple, this.messageProxy);
        fields.removeAll(header);
        fields.removeAll(patient);
        fields.removeAll(text);
        if (!this.showPatient) {
            patient = ArchetypeNodes.exclude(patient, (String[])new String[]{PATIENT});
        }
        if (!context.isEdit()) {
            patient = this.excludeEmptyPatientProperties(patient);
            header = this.excludeEmptyHeaderProperties(header);
            fields = this.excludeEmptyFields(fields);
            text = this.excludeEmptyTextProperties(text);
        }
        ComponentGrid componentGrid = new ComponentGrid();
        ComponentSet headerSet = this.createComponentSet(object, header, context);
        ComponentSet patientSet = this.createComponentSet(object, patient, context);
        ComponentSet fieldSet = this.createComponentSet(object, fields, context);
        ComponentSet textSet = this.createComponentSet(object, text, context);
        Component created = this.getCreated(properties.get(this.createdTime), object, context);
        componentGrid.set(0, 3, ComponentGrid.layout((Alignment)Alignment.ALIGN_RIGHT), created);
        componentGrid.add(headerSet, 1, 2);
        if (patientSet.size() != 0) {
            int columns = context.isEdit() ? patientSet.size() : 1;
            componentGrid.add(patientSet, columns);
        }
        componentGrid.add(fieldSet, 2);
        this.addTextComponents(componentGrid, textSet);
        Grid grid = this.createGrid(componentGrid);
        grid.setWidth(new Extent(99, 2));
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{grid}));
        this.doComplexLayout(object, parent, complex, container, context);
    }

    protected List<Property> getTextProperties(List<Property> properties, Property message) {
        ArrayList<Property> result = new ArrayList<Property>();
        result.add(message);
        result.addAll(ArchetypeNodes.include(properties, (String[])new String[]{NOTE}));
        return result;
    }

    protected void addTextComponents(ComponentGrid grid, ComponentSet components) {
        grid.add(components, 1, 2);
    }

    protected List<Property> getHeaderProperties(List<Property> properties) {
        return ArchetypeNodes.include(properties, (String[])new String[]{ADDRESS, DESCRIPTION});
    }

    protected List<Property> getPatientProperties(List<Property> properties) {
        return ArchetypeNodes.include(properties, (String[])new String[]{LOCATION, PATIENT});
    }

    protected List<Property> excludeEmptyPatientProperties(List<Property> properties) {
        return this.excludeIfEmpty(properties, PATIENT, LOCATION);
    }

    protected List<Property> excludeEmptyHeaderProperties(List<Property> properties) {
        return this.excludeIfEmpty(properties, DESCRIPTION);
    }

    protected List<Property> excludeEmptyFields(List<Property> properties) {
        return this.excludeIfEmpty(properties, REASON);
    }

    protected List<Property> excludeEmptyTextProperties(List<Property> properties) {
        return this.excludeIfEmpty(properties, NOTE);
    }

    protected List<Property> excludeIfEmpty(List<Property> properties, String ... names) {
        ArrayList<Property> result = new ArrayList<Property>(properties);
        for (Property property : properties) {
            for (String name : names) {
                if (!property.getName().equals(name) || !property.isEmpty()) continue;
                result.remove(property);
            }
        }
        return result;
    }

    protected Component getCreated(Property property, IMObject object, LayoutContext context) {
        Label result = null;
        Date date = property.getDate();
        result = date != null ? LabelFactory.text((String)DateFormatter.formatDateTimeAbbrev((Date)date)) : LabelFactory.create();
        if (object instanceof AuditableIMObject) {
            AuditInfo info = new AuditInfo((AuditableIMObject)object, context.getNames());
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{result, info});
        }
        return result;
    }
}

