/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.ObjectRelationship;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.workspace.workflow.scheduling.AbstractScheduleActEditor;
import org.openvpms.web.workspace.workflow.worklist.FollowUpTaskEditor;
import org.openvpms.web.workspace.workflow.worklist.TaskActEditor;

class TaskActRelationshipCollectionEditor
extends ActRelationshipCollectionEditor {
    public TaskActRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context);
        this.setExcludeDefaultValueObject(false);
    }

    public List<TaskType> getTasksTypes(Product product) {
        ArrayList<TaskType> result = new ArrayList<TaskType>();
        IMObjectBean bean = this.getBean((IMObject)product);
        if (bean.hasNode("tasks")) {
            RelatedIMObjects tasks = bean.getRelated("tasks", Entity.class);
            for (ObjectRelationship item : ((RelatedIMObjects)tasks.active()).getObjectRelationships()) {
                result.add(new TaskType((Entity)item.getObject(), this.getBean((IMObject)item.getRelationship())));
            }
        }
        return result;
    }

    public TaskActEditor createEditor(TaskType taskType, Party patient, Date startTime) {
        AbstractScheduleActEditor editor = null;
        Act act = (Act)this.create();
        if (act != null) {
            if (taskType.useFollowup()) {
                List<Entity> worklists = FollowUpTaskEditor.getWorkLists(this.getContext().getContext(), taskType.getType());
                editor = new FollowUpTaskEditor(act, worklists, this.createLayoutContext(act));
            } else {
                Entity worklist = (Entity)this.getObject(taskType.getWorklist());
                if (worklist != null && worklist.isActive()) {
                    editor = (TaskActEditor)this.createEditor((IMObject)act, this.createLayoutContext(act));
                    ((TaskActEditor)editor).setWorkList(worklist);
                }
            }
            if (editor != null) {
                editor.setPatient(patient);
                ((TaskActEditor)editor).setTaskType(taskType.getType());
                editor.setStartTime(DateRules.plus((Date)startTime, (Period)taskType.getStart()));
            }
        }
        if (editor != null) {
            this.addEdited((IMObjectEditor)editor);
        }
        return editor;
    }

    public void updateStartTimes(Date startTime, Product product) {
        for (Act act : this.getCurrentActs()) {
            TaskActEditor editor = (TaskActEditor)this.getEditor((IMObject)act);
            Period period = this.getTaskTypePeriod(product, editor.getTaskType());
            if (period == null) continue;
            editor.setStartTime(DateRules.plus((Date)startTime, (Period)period));
        }
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return new ChargeTaskEditor((Act)object, this.getObject(), context);
    }

    protected boolean canAdd() {
        return false;
    }

    protected void onModified(Modifiable modifiable) {
        super.onModified(modifiable);
        this.refresh();
    }

    private Period getTaskTypePeriod(Product product, Entity taskType) {
        Relationship relationship;
        Period result = null;
        IMObjectBean bean = this.getBean((IMObject)product);
        if (bean.hasNode("tasks") && (relationship = (Relationship)bean.getValue("tasks", Relationship.class, Predicates.targetEquals((IMObject)taskType))) != null) {
            TaskType type = new TaskType(taskType, this.getBean((IMObject)relationship));
            result = type.getStart();
        }
        return result;
    }

    private LayoutContext createLayoutContext(Act task) {
        LayoutContext context = this.getContext();
        return new DefaultLayoutContext(context, context.getHelpContext().topic((IMObject)task, "edit"));
    }

    private static class ChargeTaskEditor
    extends TaskActEditor {
        public ChargeTaskEditor(Act act, IMObject parent, LayoutContext context) {
            super(act, parent, context);
        }

        public IMObjectEditor newInstance() {
            return null;
        }

        @Override
        public void setTaskType(Entity taskType) {
            super.setTaskType(taskType);
            this.onLayout();
        }

        protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
            return new PropertySetBuilder(object, archetype, variables).setReadOnly("taskType").setReadOnly("worklist").setReadOnly("customer").setReadOnly("patient").build();
        }

        @Override
        protected IMObjectLayoutStrategy createLayoutStrategy() {
            return new TaskActEditor.LayoutStrategy(){

                @Override
                public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
                    this.setArchetypeNodes(new ArchetypeNodes().simple(new String[]{"worklist"}));
                    return super.apply(object, properties, parent, context);
                }
            };
        }
    }

    public static class TaskType {
        private final Entity taskType;
        private final IMObjectBean relationship;

        private TaskType(Entity taskType, IMObjectBean relationship) {
            this.relationship = relationship;
            this.taskType = taskType;
        }

        public Entity getType() {
            return this.taskType;
        }

        public boolean isInteractive() {
            return this.relationship.getBoolean("interactive");
        }

        public boolean useFollowup() {
            return this.getWorklist() == null;
        }

        public Reference getWorklist() {
            return this.relationship.getReference("worklist");
        }

        public Period getStart() {
            Period period = PeriodHelper.getPeriod((IMObjectBean)this.relationship, (String)"start", (String)"startUnits");
            return period != null ? period : Period.ZERO;
        }
    }
}

