/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.hl7.laboratory.Laboratories;
import org.openvpms.hl7.laboratory.LaboratoryOrderService;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.hl7.pharmacy.Pharmacies;
import org.openvpms.hl7.pharmacy.PharmacyOrderService;
import org.openvpms.laboratory.internal.dispatcher.OrderDispatcher;
import org.openvpms.laboratory.service.LaboratoryServices;

public class OrderServices {
    private final PharmacyOrderService pharmacyService;
    private final Pharmacies pharmacies;
    private final LaboratoryOrderService laboratoryService;
    private final Laboratories laboratories;
    private final LaboratoryServices laboratoryServices;
    private final OrderDispatcher orderDispatcher;
    private final PatientContextFactory factory;
    private final PatientInformationService informationService;
    private final MedicalRecordRules rules;
    private final PracticeRules practiceRules;

    public OrderServices(PharmacyOrderService pharmacyService, Pharmacies pharmacies, LaboratoryOrderService laboratoryService, Laboratories laboratories, LaboratoryServices laboratoryServices, OrderDispatcher orderDispatcher, PatientContextFactory factory, PatientInformationService informationService, MedicalRecordRules rules, PracticeRules practiceRules) {
        this.pharmacyService = pharmacyService;
        this.pharmacies = pharmacies;
        this.laboratoryService = laboratoryService;
        this.laboratories = laboratories;
        this.laboratoryServices = laboratoryServices;
        this.orderDispatcher = orderDispatcher;
        this.factory = factory;
        this.informationService = informationService;
        this.rules = rules;
        this.practiceRules = practiceRules;
    }

    public PharmacyOrderService getPharmacyService() {
        return this.pharmacyService;
    }

    public LaboratoryOrderService getLaboratoryService() {
        return this.laboratoryService;
    }

    public PatientContextFactory getFactory() {
        return this.factory;
    }

    public PatientInformationService getInformationService() {
        return this.informationService;
    }

    public MedicalRecordRules getRules() {
        return this.rules;
    }

    public Pharmacies getPharmacies() {
        return this.pharmacies;
    }

    public PracticeRules getPracticeRules() {
        return this.practiceRules;
    }

    public Entity getService(Entity group, Party location) {
        if (TypeHelper.isA((IMObject)group, (String)"entity.HL7ServicePharmacyGroup")) {
            return this.pharmacies.getService(group, location.getObjectReference());
        }
        if (TypeHelper.isA((IMObject)group, (String)"entity.HL7ServiceLaboratoryGroup")) {
            return this.laboratories.getService(group, location.getObjectReference());
        }
        return null;
    }

    public LaboratoryServices getLaboratoryServices() {
        return this.laboratoryServices;
    }

    public OrderDispatcher getOrderDispatcher() {
        return this.orderDispatcher;
    }
}

