/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.apache.commons.lang3.mutable.MutableBoolean;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActEditDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.DefaultEditorQueue;
import org.openvpms.web.workspace.customer.charge.OrderChargeManager;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderChecker;
import org.openvpms.web.workspace.customer.order.OrderCharger;
import org.openvpms.web.workspace.customer.order.OrderChargerFactory;

public abstract class CustomerChargeActEditDialog
extends ActEditDialog {
    private final OrderChargeManager manager;
    private final boolean autoChargeOrders;
    private static final String COMPLETED_ID = "button.completed";
    private static final String IN_PROGRESS_ID = "button.inprogress";
    private static final String INVOICE_ORDERS_ID = "button.invoiceOrders";
    private static final String SUBMIT_INVESTIGATIONS_ID = "button.submitInvestigations";

    public CustomerChargeActEditDialog(CustomerChargeActEditor editor, Context context) {
        this(editor, null, context, true);
    }

    public CustomerChargeActEditDialog(CustomerChargeActEditor editor, OrderCharger charger, Context context, boolean autoChargeOrders) {
        super((IMObjectEditor)editor, context);
        this.addButton(COMPLETED_ID);
        this.addButton(IN_PROGRESS_ID);
        this.addButton(INVOICE_ORDERS_ID);
        if (editor.getObject().isA("act.customerAccountChargesInvoice")) {
            this.addButton(SUBMIT_INVESTIGATIONS_ID);
        }
        this.setDefaultCloseAction("cancel");
        if (charger == null) {
            OrderChargerFactory factory = (OrderChargerFactory)ServiceHelper.getBean(OrderChargerFactory.class);
            HelpContext help = editor.getHelpContext().subtopic("order");
            charger = factory.create(editor.getCustomer(), context, help);
        }
        this.autoChargeOrders = autoChargeOrders;
        this.manager = new OrderChargeManager(charger, this.getAlertListener());
    }

    public void show() {
        super.show();
        if (this.autoChargeOrders) {
            this.manager.charge(this.getEditor());
        } else {
            this.manager.check();
        }
    }

    public CustomerChargeActEditor getEditor() {
        return (CustomerChargeActEditor)super.getEditor();
    }

    public void checkOrders() {
        this.manager.check();
    }

    public void submitInvestigations() {
        if (!this.isCurrentlyPosted()) {
            if (this.save()) {
                this.getEditor().submitInvestigations();
            }
        } else {
            InformationDialog.show((String)Messages.get((String)"customer.charge.investigation.submit.title"), (String)Messages.get((String)"customer.charge.investigation.posted.message"));
        }
    }

    protected void onOK() {
        this.prepare(true);
    }

    protected void onApply() {
        this.prepare(false);
    }

    protected void doSave(IMObjectEditor editor) {
        super.doSave(editor);
        this.manager.save();
        this.manager.clear();
    }

    protected void setEditor(IMObjectEditor editor) {
        CustomerChargeActEditor existing = this.getEditor();
        if (existing != null) {
            existing.setAddItemListener(null);
            existing.setAlertListener(null);
        }
        super.setEditor(editor);
        if (editor != null) {
            CustomerChargeActEditor chargeActEditor = (CustomerChargeActEditor)editor;
            chargeActEditor.setAddItemListener(this::autoSave);
        }
    }

    protected boolean reload(IMObjectEditor editor) {
        this.manager.clear();
        return super.reload(editor);
    }

    protected void reloaded(String title, String message, IMObjectEditor oldEditor) {
        CustomerChargeActEditor editor = this.getEditor();
        editor.getEditorQueue().queue((PopupDialog)new ErrorDialog(title, message));
    }

    protected void onButton(String button) {
        if (IN_PROGRESS_ID.equals(button)) {
            this.onInProgress();
        } else if (COMPLETED_ID.equals(button)) {
            this.onCompleted();
        } else if (INVOICE_ORDERS_ID.equals(button)) {
            this.chargeOrders();
        } else if (SUBMIT_INVESTIGATIONS_ID.equals(button)) {
            this.submitInvestigations();
        } else {
            super.onButton(button);
        }
    }

    private void prepare(boolean close) {
        UndispensedOrderChecker checker = new UndispensedOrderChecker(this.getEditor());
        checker.confirm(this.getHelpContext(), () -> this.saveCharge(close));
    }

    private void saveCharge(final boolean close) {
        if (this.save()) {
            final MutableBoolean cancelled = new MutableBoolean(false);
            DefaultEditorQueue queue = new DefaultEditorQueue(false, this.getContext()){

                @Override
                protected void completed() {
                    if (close && !cancelled.booleanValue()) {
                        CustomerChargeActEditDialog.this.close("ok");
                    }
                }
            };
            this.getEditor().postSave(queue, close, cancelled);
            queue.start();
        } else {
            this.manager.check();
        }
    }

    private void onInProgress() {
        if (!this.isPosted()) {
            CustomerChargeActEditor editor = this.getEditor();
            editor.setStatus("IN_PROGRESS");
            this.onOK();
        }
    }

    private void onCompleted() {
        if (!this.isPosted()) {
            CustomerChargeActEditor editor = this.getEditor();
            editor.setStatus("COMPLETED");
            this.onOK();
        }
    }

    private void chargeOrders() {
        if (!this.isPosted()) {
            this.manager.chargeSelected(this.getEditor());
        }
    }

    private void autoSave() {
        CustomerChargeActEditor editor = this.getEditor();
        FinancialAct object = editor.getObject();
        if (!object.isNew() && !this.isCurrentlyPosted() && editor.isValid()) {
            this.save();
        }
    }

    private boolean isCurrentlyPosted() {
        return "POSTED".equals(this.getEditor().getStatus());
    }
}

