/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.patient.prescription.PrescriptionRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.im.edit.ActCollectionResultSetFactory;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.RemoveConfirmationHandler;
import org.openvpms.web.component.im.edit.act.ActItemEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.PriceActItemEditor;
import org.openvpms.web.workspace.customer.StockOnHand;
import org.openvpms.web.workspace.customer.charge.AbstractChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.Alerts;
import org.openvpms.web.workspace.customer.charge.ChargeItemTableModel;
import org.openvpms.web.workspace.customer.charge.ChargeSaveContext;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeEditContext;
import org.openvpms.web.workspace.customer.charge.DefaultChargeRemoveConfirmationHandler;
import org.openvpms.web.workspace.customer.charge.DefaultCustomerChargeActItemEditor;
import org.openvpms.web.workspace.customer.charge.EditorQueue;
import org.openvpms.web.workspace.customer.charge.InvestigationManager;
import org.openvpms.web.workspace.customer.charge.InvoiceRemoveConfirmationHandler;
import org.openvpms.web.workspace.customer.charge.department.DepartmentListener;
import org.openvpms.web.workspace.patient.charge.TemplateChargeItems;
import org.openvpms.web.workspace.patient.mr.Prescriptions;

public class ChargeItemRelationshipCollectionEditor
extends AbstractChargeItemRelationshipCollectionEditor {
    private final List<TemplateChargeItems> templates = new ArrayList<TemplateChargeItems>();
    private final DepartmentListener departmentListener;
    private Date lastItemDate = null;
    private Runnable listener;
    private String alertId;
    private static final String START_TIME = "startTime";

    public ChargeItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        this(property, act, context, ActCollectionResultSetFactory.INSTANCE);
    }

    public ChargeItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context, CollectionResultSetFactory factory) {
        super(property, act, context, factory, ChargeItemRelationshipCollectionEditor.createEditContext(act, context));
        Prescriptions prescriptions = null;
        CustomerChargeEditContext editContext = this.getEditContext();
        if (act.isA("act.customerAccountChargesInvoice")) {
            List items = this.getCurrentActs();
            InvestigationManager investigationManager = editContext.getInvestigations();
            for (Act item : items) {
                investigationManager.addInvoiceItem((FinancialAct)item);
            }
            prescriptions = new Prescriptions(items, (PrescriptionRules)ServiceHelper.getBean(PrescriptionRules.class), (ArchetypeService)ServiceHelper.getArchetypeService());
            this.setRemoveConfirmationHandler((RemoveConfirmationHandler)new InvoiceRemoveConfirmationHandler(investigationManager, context.getContext(), context.getHelpContext()));
        } else {
            this.setRemoveConfirmationHandler((RemoveConfirmationHandler)new DefaultChargeRemoveConfirmationHandler(context.getContext(), context.getHelpContext()));
        }
        editContext.setPrescriptions(prescriptions);
        this.departmentListener = editContext.useDepartments() ? this::onDepartmentChanged : null;
    }

    public ChargeSaveContext getSaveContext() {
        return this.getEditContext().getSaveContext();
    }

    public void setEditorQueue(EditorQueue queue) {
        this.getEditContext().setEditorQueue(queue);
    }

    public EditorQueue getEditorQueue() {
        return this.getEditContext().getEditorQueue();
    }

    public void remove(IMObject object) {
        super.remove(object);
        FinancialAct act = (FinancialAct)object;
        CustomerChargeEditContext editContext = this.getEditContext();
        editContext.getStock().remove(act);
        Prescriptions prescriptions = editContext.getPrescriptions();
        if (prescriptions != null) {
            prescriptions.removeItem((Act)act);
        }
        InvestigationManager investigations = this.getEditContext().getInvestigations();
        investigations.removeInvoiceItem(act);
        Alerts alerts = editContext.getAlerts();
        alerts.removeItem(act);
        EditorQueue queue = this.getEditorQueue();
        if (queue != null) {
            queue.cancel(object);
        }
    }

    public void setAddItemListener(Runnable listener) {
        this.listener = listener;
    }

    public List<TemplateChargeItems> getTemplates() {
        return this.templates;
    }

    public void clearTemplates() {
        this.templates.clear();
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        return this.initialiseEditor(new DefaultCustomerChargeActItemEditor((FinancialAct)object, (Act)this.getObject(), this.getEditContext(), context));
    }

    public CustomerChargeActItemEditor getEditor(IMObject object) {
        return (CustomerChargeActItemEditor)super.getEditor(object);
    }

    public void posted(Date date) {
        for (Act act : this.getCurrentActs()) {
            act.setActivityEndTime(date);
        }
    }

    public PricingContext getPricingContext() {
        return this.getEditContext().getPricingContext();
    }

    public boolean isModified() {
        return super.isModified() || this.getEditContext().getInvestigations().isModified();
    }

    protected boolean doValidation(Validator validator) {
        if (super.doValidation(validator) && this.validateInvestigations(validator)) {
            EditorQueue queue = this.getEditorQueue();
            return queue == null || queue.isComplete();
        }
        return false;
    }

    @Override
    protected IMObjectEditor onAdd() {
        this.unmarkAll();
        IMObjectEditor editor = this.add();
        if (editor != null && this.listener != null) {
            EditorQueue queue = this.getEditorQueue();
            if (!queue.isComplete()) {
                queue.queue(() -> {
                    if (this.listener != null) {
                        this.listener.run();
                    }
                });
            } else {
                this.listener.run();
            }
        }
        return editor;
    }

    @Override
    protected CustomerChargeEditContext getEditContext() {
        return (CustomerChargeEditContext)super.getEditContext();
    }

    protected CustomerChargeActItemEditor initialiseEditor(CustomerChargeActItemEditor editor) {
        if (this.lastItemDate != null) {
            editor.getProperty(START_TIME).setValue((Object)this.lastItemDate);
        }
        ModifiableListener startTimeListener = modifiable -> {
            this.lastItemDate = editor.getProperty(START_TIME).getDate();
        };
        editor.getProperty(START_TIME).addModifiableListener(startTimeListener);
        editor.setProductListener(this.getProductListener());
        editor.setDepartmentListener(this.departmentListener);
        editor.setAlertListener(this.getAlertListener());
        return editor;
    }

    protected IMObjectEditor edit(IMObject object) {
        CustomerChargeActItemEditor editor = (CustomerChargeActItemEditor)super.edit(object);
        editor.updateOnHandQuantity();
        return editor;
    }

    protected List<Act> createTemplateActs(ActItemEditor editor, Product template, BigDecimal quantity) {
        AlertListener alertListener;
        List acts = super.createTemplateActs(editor, template, quantity);
        if (!acts.isEmpty()) {
            TemplateChargeItems items = new TemplateChargeItems(template, acts);
            this.templates.add(items);
        }
        if ((alertListener = this.getAlertListener()) != null && !acts.isEmpty()) {
            int outOfStock = 0;
            StockOnHand stock = this.getEditContext().getStock();
            for (Act act : acts) {
                BigDecimal onHand = stock.getAvailableStock((FinancialAct)act);
                if (onHand == null || BigDecimal.ZERO.compareTo(onHand) < 0) continue;
                ++outOfStock;
            }
            if (outOfStock != 0) {
                if (this.alertId != null) {
                    alertListener.cancel(this.alertId);
                    this.alertId = null;
                }
                this.alertId = alertListener.onAlert(Messages.format((String)"customer.charge.outofstock", (Object[])new Object[]{outOfStock}));
            }
        }
        EditorQueue queue = this.getEditorQueue();
        if (!acts.isEmpty() && !queue.isComplete()) {
            queue.queue(() -> {
                this.getListeners().notifyListeners((Modifiable)this);
                this.isValid();
                IMObjectEditor currentEditor = this.getCurrentEditor();
                if (currentEditor instanceof PriceActItemEditor) {
                    ((PriceActItemEditor)currentEditor).moveFocusToProduct();
                }
            });
        }
        return acts;
    }

    protected void doSave() {
        CustomerChargeEditContext editContext = this.getEditContext();
        Prescriptions prescriptions = editContext.getPrescriptions();
        if (prescriptions != null) {
            prescriptions.save();
        }
        InvestigationManager investigations = editContext.getInvestigations();
        investigations.save();
        super.doSave();
        editContext.getStock().clear();
    }

    @Override
    protected ChargeItemTableModel<Act> createChargeItemTableModel(LayoutContext context) {
        CustomerChargeEditContext editContext = this.getEditContext();
        return new ChargeItemTableModel<Act>(this.getCollectionPropertyEditor().getArchetypeRange(), editContext.getStock(), context);
    }

    private void onDepartmentChanged(CustomerChargeActItemEditor editor, Entity department) {
        List<IMObject> marked = this.getMarked();
        marked.remove(editor.getObject());
        if (marked.isEmpty()) {
            List<CustomerChargeActItemEditor> editors;
            Product template = editor.getTemplate();
            if (template != null && !(editors = this.getEditorsForTemplate(editor, (Entity)template, department)).isEmpty()) {
                ConfirmationDialog dialog = ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"customer.charge.department.change.title"))).message(Messages.format((String)"customer.charge.department.change.template", (Object[])new Object[]{editors.size(), template.getName()}))).yesNo()).yes(() -> this.changeDepartments(editors, department))).build();
                this.getEditorQueue().queue((PopupDialog)dialog);
            }
        } else {
            ArrayList<CustomerChargeActItemEditor> editors = new ArrayList<CustomerChargeActItemEditor>();
            for (IMObject object : marked) {
                editors.add(this.getEditor(object));
            }
            ConfirmationDialog dialog = ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"customer.charge.department.change.title"))).message(Messages.format((String)"customer.charge.department.change.message", (Object[])new Object[]{editors.size()}))).yesNo()).yes(() -> this.changeDepartments(editors, department))).build();
            this.getEditorQueue().queue((PopupDialog)dialog);
        }
    }

    private List<CustomerChargeActItemEditor> getEditorsForTemplate(CustomerChargeActItemEditor editor, Entity template, Entity department) {
        Reference templateRef = template.getObjectReference();
        int group = editor.getTemplateGroup();
        ArrayList<CustomerChargeActItemEditor> editors = new ArrayList<CustomerChargeActItemEditor>();
        if (group != -1) {
            Reference departmentRef = department != null ? department.getObjectReference() : null;
            for (Act object : this.getCurrentActs()) {
                CustomerChargeActItemEditor other;
                if (object == editor.getObject() || !Objects.equals(templateRef, (other = this.getEditor((IMObject)object)).getTemplateRef()) || group != other.getTemplateGroup() || Objects.equals(other.getDepartmentRef(), departmentRef)) continue;
                editors.add(other);
            }
        }
        return editors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeDepartments(List<CustomerChargeActItemEditor> editors, Entity department) {
        for (CustomerChargeActItemEditor editor : editors) {
            editor.setDepartmentListener(null);
            try {
                editor.setDepartment(department);
            }
            finally {
                editor.setDepartmentListener(this.departmentListener);
            }
        }
        this.unmarkAll();
    }

    private boolean validateInvestigations(Validator validator) {
        InvestigationManager investigationManager = this.getEditContext().getInvestigations();
        return investigationManager.validate(validator);
    }

    private static CustomerChargeEditContext createEditContext(Act act, LayoutContext context) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        Party customer = (Party)IMObjectHelper.getObject((Reference)bean.getTargetRef("customer"), (Context)context.getContext());
        if (customer == null) {
            throw new IllegalStateException(act.getArchetype() + " has no customer");
        }
        Party location = (Party)IMObjectHelper.getObject((Reference)bean.getTargetRef("location"), (Context)context.getContext());
        return new CustomerChargeEditContext(customer, location, context);
    }
}

