/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.ChargeItemRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditDialog;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActEditor;
import org.openvpms.web.workspace.customer.charge.CustomerChargeActItemEditor;

public abstract class AbstractInvoicer {
    public FinancialAct createInvoice(Party customer) {
        return this.createInvoice(customer != null ? customer.getObjectReference() : null);
    }

    public FinancialAct createInvoice(Reference customer) {
        return this.createCharge("act.customerAccountChargesInvoice", customer);
    }

    protected CustomerChargeActEditor createChargeEditor(FinancialAct invoice, LayoutContext context) {
        IMObjectEditorFactory factory = context.getEditorFactory();
        CustomerChargeActEditor editor = (CustomerChargeActEditor)factory.create((IMObject)invoice, context);
        editor.setAddDefaultItem(false);
        return editor;
    }

    protected FinancialAct createCharge(String shortName, Reference customer) {
        FinancialAct result = (FinancialAct)IMObjectCreator.create((String)shortName);
        if (result == null) {
            throw new IllegalStateException("Failed to create " + shortName);
        }
        IMObjectBean invoiceBean = this.getBean((IMObject)result);
        if (customer != null) {
            invoiceBean.setTarget("customer", customer);
        }
        return result;
    }

    protected CustomerChargeActItemEditor getItemEditor(CustomerChargeActEditor editor) {
        CustomerChargeActItemEditor result;
        ChargeItemRelationshipCollectionEditor items = editor.getItems();
        IMObjectEditor currentEditor = items.getCurrentEditor();
        if (currentEditor instanceof CustomerChargeActItemEditor && ((CustomerChargeActItemEditor)currentEditor).getProductRef() == null) {
            result = (CustomerChargeActItemEditor)currentEditor;
        } else {
            Act act = (Act)items.create();
            if (act == null) {
                throw new IllegalStateException("Failed to create charge item");
            }
            result = this.getItemEditor(act, editor);
        }
        return result;
    }

    protected CustomerChargeActItemEditor getItemEditor(Act act, CustomerChargeActEditor editor) {
        ChargeItemRelationshipCollectionEditor items = editor.getItems();
        CustomerChargeActItemEditor result = (CustomerChargeActItemEditor)items.getEditor((IMObject)act);
        result.getComponent();
        items.addEdited((IMObjectEditor)result);
        items.setModified(act, true);
        return result;
    }

    protected IMObjectBean getBean(IMObject object) {
        return ServiceHelper.getArchetypeService().getBean(object);
    }

    protected static class ChargeDialog
    extends CustomerChargeActEditDialog {
        private final Act act;
        private boolean saved = false;

        public ChargeDialog(CustomerChargeActEditor editor, Act act, Context context) {
            super(editor, null, context, false);
            this.act = act;
        }

        @Override
        protected void doSave(IMObjectEditor editor) {
            super.doSave(editor);
            if (!this.saved) {
                ServiceHelper.getArchetypeService().save((IMObject)this.act);
                this.saved = true;
            }
        }
    }
}

