/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.charge;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.CollectionResultSetFactory;
import org.openvpms.web.component.im.edit.DefaultCollectionResultSetFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.ProductTemplateExpander;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.component.im.table.MarkablePagedIMObjectTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.workspace.customer.charge.ChargeItemTableModel;
import org.openvpms.web.workspace.customer.charge.ChargeRemoveConfirmationHandler;
import org.openvpms.web.workspace.customer.charge.PriceActEditContext;

public abstract class AbstractChargeItemRelationshipCollectionEditor
extends ActRelationshipCollectionEditor {
    private final PriceActEditContext editContext;
    static final String SHOW_BATCH = "showBatch";
    static final String SHOW_TEMPLATE = "showTemplate";
    static final String SHOW_PRODUCT_TYPE = "showProductType";
    private static final String SHOW_DEPARTMENT = "showDepartment";

    public AbstractChargeItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context, PriceActEditContext editContext) {
        this(property, act, context, DefaultCollectionResultSetFactory.INSTANCE, editContext);
    }

    public AbstractChargeItemRelationshipCollectionEditor(CollectionProperty property, Act act, LayoutContext context, CollectionResultSetFactory factory, PriceActEditContext editContext) {
        super(property, act, context, factory);
        this.editContext = editContext;
    }

    public void unmarkAll() {
        MarkablePagedIMObjectTableModel model = (MarkablePagedIMObjectTableModel)this.getTable().getModel();
        model.unmarkAll();
    }

    protected IMObjectEditor onAdd() {
        this.unmarkAll();
        return super.onAdd();
    }

    protected PriceActEditContext getEditContext() {
        return this.editContext;
    }

    protected PagedIMTable<IMObject> createTable(IMTableModel<IMObject> model) {
        return new PagedIMTable((IMTableModel)new MarkablePagedIMObjectTableModel((IMObjectTableModel)model));
    }

    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        context = new DefaultLayoutContext(context);
        TableComponentFactory factory = new TableComponentFactory(context);
        factory.setTruncateLongText(true);
        context.setComponentFactory((IMObjectComponentFactory)factory);
        ChargeItemTableModel<Act> model = this.createChargeItemTableModel(context);
        ListMarkModel rowMarkModel = model.getRowMarkModel();
        if (rowMarkModel != null) {
            rowMarkModel.addListener(new ListMarkModel.Listener(){

                public void changed(int index, boolean marked) {
                    AbstractChargeItemRelationshipCollectionEditor.this.enableDelete();
                }

                public void cleared() {
                    AbstractChargeItemRelationshipCollectionEditor.this.enableDelete();
                }
            });
        }
        return model;
    }

    protected ChargeItemTableModel<Act> createChargeItemTableModel(LayoutContext context) {
        return new ChargeItemTableModel<Act>(this.getCollectionPropertyEditor().getArchetypeRange(), null, context);
    }

    protected ButtonRow createControls(FocusGroup focus) {
        ButtonRow controls = super.createControls(focus);
        final Preferences preferences = this.getContext().getPreferences();
        boolean showBatch = preferences.getBoolean("entity.preferenceGroupCharge", SHOW_BATCH, false);
        boolean showTemplate = preferences.getBoolean("entity.preferenceGroupCharge", SHOW_TEMPLATE, false);
        boolean showProductType = preferences.getBoolean("entity.preferenceGroupCharge", SHOW_PRODUCT_TYPE, false);
        boolean showDepartment = preferences.getBoolean("entity.preferenceGroupCharge", SHOW_DEPARTMENT, false);
        ChargeItemTableModel<Act> model = this.getModel();
        if (model.hasBatch()) {
            final CheckBox batch = CheckBoxFactory.create((String)"customer.charge.show.batch", (boolean)showBatch);
            batch.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    boolean selected = batch.isSelected();
                    preferences.setPreference("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_BATCH, (Object)selected);
                    AbstractChargeItemRelationshipCollectionEditor.this.getModel().setShowBatch(preferences.getBoolean("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_BATCH, false));
                }
            });
            controls.add((Component)batch);
        }
        final CheckBox template = CheckBoxFactory.create((String)"customer.charge.show.template", (boolean)showTemplate);
        final CheckBox productType = CheckBoxFactory.create((String)"customer.charge.show.productType", (boolean)showProductType);
        template.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                boolean selected = template.isSelected();
                preferences.setPreference("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_TEMPLATE, (Object)selected);
                AbstractChargeItemRelationshipCollectionEditor.this.getModel().setShowTemplate(selected);
            }
        });
        productType.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                boolean selected = productType.isSelected();
                preferences.setPreference("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_PRODUCT_TYPE, (Object)selected);
                AbstractChargeItemRelationshipCollectionEditor.this.getModel().setShowProductType(selected);
            }
        });
        controls.add((Component)template);
        controls.add((Component)productType);
        if (this.editContext.useDepartments()) {
            final CheckBox department = CheckBoxFactory.create((String)"customer.charge.show.department", (boolean)showDepartment);
            department.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    boolean selected = department.isSelected();
                    preferences.setPreference("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_DEPARTMENT, (Object)selected);
                    AbstractChargeItemRelationshipCollectionEditor.this.getModel().setShowDepartment(preferences.getBoolean("entity.preferenceGroupCharge", AbstractChargeItemRelationshipCollectionEditor.SHOW_DEPARTMENT, false));
                }
            });
            controls.add((Component)department);
        }
        return controls;
    }

    protected boolean getEnableDelete() {
        boolean result = super.getEnableDelete();
        if (!result) {
            result = ((MarkablePagedIMObjectTableModel)this.getTable().getModel()).isMarked();
        }
        return result;
    }

    protected ProductTemplateExpander getProductTemplateExpander() {
        PriceActEditContext context = this.getEditContext();
        return new ProductTemplateExpander(context.useLocationProducts(), context.getLocation(), context.getStockLocation());
    }

    protected void onDelete() {
        List<IMObject> items = this.getMarked();
        if (!items.isEmpty()) {
            ChargeRemoveConfirmationHandler handler = (ChargeRemoveConfirmationHandler)this.getRemoveConfirmationHandler();
            handler.remove(items, this);
        } else {
            super.onDelete();
        }
    }

    protected List<IMObject> getMarked() {
        MarkablePagedIMObjectTableModel model = (MarkablePagedIMObjectTableModel)this.getTable().getModel();
        return model.getMarked(this.getCurrentObjects());
    }

    protected PagedIMTable<IMObject> getTable() {
        return super.getTable();
    }

    protected ChargeItemTableModel<Act> getModel() {
        IMTableModel model = this.getTable().getModel().getModel();
        return (ChargeItemTableModel)model;
    }
}

