/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account.payment;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.account.payment.AdminPaymentActRelationshipCollectionEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentLayoutStrategy;
import org.openvpms.web.workspace.customer.payment.PaymentStatus;

public class AdminCustomerPaymentEditor
extends CustomerPaymentEditor {
    public AdminCustomerPaymentEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        if (act.isNew() || !"POSTED".equals(act.getStatus()) || !act.isA("act.customerAccountPayment")) {
            throw new IllegalArgumentException("Argument 'act' must be saved and have POSTED status");
        }
        this.setExpectedAmount(act.getTotal());
    }

    @Override
    public IMObjectEditor newInstance() {
        return new AdminCustomerPaymentEditor(this.reloadPayment(), this.getParent(), this.getLayoutContext());
    }

    protected void doSave() {
        this.updateAudit();
        super.doSave();
    }

    @Override
    protected ActRelationshipCollectionEditor createItemsEditor(Act act, CollectionProperty items) {
        return new AdminPaymentActRelationshipCollectionEditor(items, (Act)this.getObject(), this.getLayoutContext());
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateInvariants(validator) && this.validateTillBalance(validator);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AdminLayoutStrategy((IMObjectCollectionEditor)this.getItems(), this.getPaymentStatus());
    }

    protected IArchetypeService getService() {
        return ServiceHelper.getArchetypeService((boolean)false);
    }

    private void updateAudit() {
        String message = ((AdminPaymentActRelationshipCollectionEditor)this.getItems()).getAuditMessage();
        if (message != null) {
            Property audit = this.getProperty("audit");
            StringBuilder builder = new StringBuilder(audit.getString(""));
            if (builder.length() != 0) {
                builder.append('\n');
            }
            builder.append(message);
            audit.setValue((Object)StringUtils.abbreviate((String)builder.toString(), (int)audit.getMaxLength()));
        }
    }

    private boolean validateInvariants(Validator validator) {
        boolean valid = false;
        if (!"POSTED".equals(this.getStatus())) {
            validator.add((Modifiable)this, "Status must be POSTED");
        } else {
            valid = true;
        }
        return valid;
    }

    private boolean validateTillBalance(Validator validator) {
        boolean valid = false;
        if (this.getRules().hasClearedTillBalance(this.getObject())) {
            validator.add((Modifiable)this, Messages.get((String)"customer.account.payment.clearedtill.message"));
        } else {
            valid = true;
        }
        return valid;
    }

    private static class AdminLayoutStrategy
    extends CustomerPaymentLayoutStrategy {
        public AdminLayoutStrategy(IMObjectCollectionEditor editor, PaymentStatus status) {
            super(editor, status);
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            MutablePropertySet readOnly = new MutablePropertySet(properties);
            for (Property property : properties.getEditable()) {
                readOnly.setReadOnly(property.getName());
            }
            return super.apply(object, (PropertySet)readOnly, parent, context);
        }
    }
}

