/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSTemplateEvaluator;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.account.AccountReminderException;

public class AccountReminderEvaluator {
    private final Party practice;
    private final SMSTemplateEvaluator evaluator;
    private final ArchetypeService service;
    private final LookupService lookups;

    public AccountReminderEvaluator(Party practice, SMSTemplateEvaluator evaluator, ArchetypeService service, LookupService lookups) {
        this.practice = practice;
        this.evaluator = evaluator;
        this.service = service;
        this.lookups = lookups;
    }

    public String evaluate(Entity template, FinancialAct charge, Party customer, Party location) {
        String result;
        LocalContext context = new LocalContext();
        context.setCustomer(customer);
        context.setLocation(location);
        context.setPractice(this.practice);
        MacroVariables variables = new MacroVariables((Context)context, this.service, this.lookups);
        BigDecimal balance = MathRules.round((BigDecimal)charge.getTotal().subtract(charge.getAllocatedAmount()));
        variables.add("balance", (Object)balance);
        variables.add("charge", (Object)charge);
        try {
            result = this.evaluator.evaluate(template, (Object)charge, variables);
        }
        catch (Throwable exception) {
            throw new AccountReminderException(Messages.format((String)"reporting.reminder.smsevaluatefailed", (Object[])new Object[]{template.getName()}), exception);
        }
        return result;
    }
}

