/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer.account;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.relationship.RelationshipHelper;
import org.openvpms.web.component.im.table.BaseIMObjectTableModel;
import org.openvpms.web.echo.table.TableColumnFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

public class AccountAllocationRelationshipTableModel
extends BaseIMObjectTableModel<IMObject> {
    private final Reference parent;
    private final ArchetypeService service;
    private final Map<IMObject, FinancialAct> acts = new HashMap<IMObject, FinancialAct>();
    private static final int DATE_INDEX = 6;
    private static final int ALLOCATED_AMOUNT_INDEX = 7;
    private static final String ALLOCATED_AMOUNT = "allocatedAmount";

    public AccountAllocationRelationshipTableModel(FinancialAct parent) {
        super(null);
        this.parent = parent.getObjectReference();
        this.service = ServiceHelper.getArchetypeService();
        this.setTableColumnModel(this.createTableColumnModel());
    }

    public void setObjects(List<IMObject> objects) {
        super.setObjects(objects);
        this.acts.clear();
        for (IMObject object : objects) {
            Reference reference = RelationshipHelper.getRelated((Reference)this.parent, (Relationship)((ActRelationship)object));
            FinancialAct other = (FinancialAct)this.service.get(reference, FinancialAct.class);
            this.acts.put(object, other);
        }
    }

    protected Object getValue(IMObject object, TableColumn column, int row) {
        Object result = null;
        if (column.getModelIndex() == 1 || column.getModelIndex() == 2) {
            result = (object = (IMObject)this.acts.get(object)) != null ? super.getValue(object, column, row) : null;
        } else if (column.getModelIndex() == 6) {
            Date date;
            Act act = (Act)this.acts.get(object);
            Date date2 = date = act != null ? act.getActivityStartTime() : null;
            if (date != null) {
                result = DateFormatter.formatDate((Date)date, (boolean)false);
            }
        } else if (column.getModelIndex() == 7) {
            BigDecimal amount = this.service.getBean(object).getBigDecimal(ALLOCATED_AMOUNT, BigDecimal.ZERO);
            result = TableHelper.rightAlign((String)NumberFormatter.format((Number)amount));
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(AccountAllocationRelationshipTableModel.createTableColumn((int)1, (String)"table.imobject.id"));
        model.addColumn(AccountAllocationRelationshipTableModel.createTableColumn((int)6, (String)"table.act.date"));
        model.addColumn(AccountAllocationRelationshipTableModel.createTableColumn((int)2, (String)"table.act.type"));
        String allocatedAmount = DescriptorHelper.getDisplayName((String)"actRelationship.customerAccountAllocation", (String)ALLOCATED_AMOUNT, (ArchetypeService)this.service);
        model.addColumn(TableColumnFactory.create((int)7, (Object)allocatedAmount));
        return model;
    }
}

