/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import org.openvpms.archetype.rules.prefs.PreferenceMonitor;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.customer.BillingCustomerMailContext;
import org.openvpms.web.workspace.customer.CustomerActWorkspace;
import org.openvpms.web.workspace.customer.CustomerMailContext;

public abstract class CustomerFinancialWorkspace<T extends Act>
extends CustomerActWorkspace<T> {
    private final PreferenceMonitor monitor;

    public CustomerFinancialWorkspace(String id, Context context, Preferences preferences) {
        super(id, context, preferences);
        this.monitor = new PreferenceMonitor(preferences);
        this.monitor.add("entity.preferenceGroupCharge");
    }

    @Override
    public void show() {
        super.show();
        this.checkPreferences();
    }

    public void preferencesChanged() {
        this.checkPreferences();
    }

    @Override
    protected CustomerMailContext createMailContext(Context context, HelpContext help) {
        return new BillingCustomerMailContext(context, help);
    }

    protected void checkPreferences() {
        CRUDWindow window;
        if (this.monitor.changed() && (window = this.getCRUDWindow()) != null) {
            Act object = (Act)window.getObject();
            window.setObject((IMObject)object);
        }
    }
}

