/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.customer;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.customer.CustomerBrowser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.QueryBrowserCRUDWorkspace;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.customer.CustomerSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;

public abstract class CustomerActWorkspace<T extends Act>
extends QueryBrowserCRUDWorkspace<Party, T> {
    private final Preferences preferences;
    private final MandatoryAlerts alerts;

    public CustomerActWorkspace(String id, Context context, Preferences preferences) {
        this(id, null, context, preferences);
    }

    public CustomerActWorkspace(String id, Archetypes<T> actArchetypes, Context context, Preferences preferences) {
        super(id, null, actArchetypes, context);
        this.setArchetypes(Party.class, new String[]{"party.customer*"});
        this.preferences = preferences;
        this.alerts = new MandatoryAlerts(context, this.getHelpContext());
        this.setMailContext((MailContext)this.createMailContext(context, this.getHelpContext()));
    }

    public void setObject(Party object) {
        ContextHelper.setCustomer((Context)this.getContext(), (Party)object);
        super.setObject((IMObject)object);
        this.firePropertyChange("summary", null, null);
    }

    public void show() {
        super.show();
        this.alerts.show((Party)this.getObject());
    }

    public Component getSummary() {
        CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
        CustomerSummary summarizer = factory.createCustomerSummary(this.getContext(), this.getHelpContext(), this.preferences);
        return summarizer.getSummary((Party)this.getObject());
    }

    protected CustomerMailContext createMailContext(Context context, HelpContext help) {
        return new CustomerMailContext(context, true, this.getHelpContext());
    }

    protected Party getLatest() {
        return (Party)this.getLatest((IMObject)this.getContext().getCustomer());
    }

    protected void onSelectClosed(BrowserDialog<Party> dialog) {
        Party customer = (Party)dialog.getSelected();
        if (customer != null) {
            CustomerBrowser browser;
            Party patient;
            this.onSelected(customer);
            if (dialog.getBrowser() instanceof CustomerBrowser && (patient = (browser = (CustomerBrowser)dialog.getBrowser()).getPatient()) != null) {
                ContextHelper.setPatient((Context)this.getContext(), (Party)patient);
            }
        }
    }

    protected void onSelected(Party object) {
        super.onSelected((IMObject)object);
        this.alerts.show((Party)this.getObject());
    }
}

