/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.alert;

import java.util.List;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextField;

public class AlertLayoutStrategy
extends AbstractLayoutStrategy {
    private final TextField priority;
    private Alert alert;

    public AlertLayoutStrategy() {
        this(TextComponentFactory.create());
    }

    public AlertLayoutStrategy(TextField priority) {
        this.priority = priority;
        priority.setWidth(new Extent(15, 128));
        priority.setEnabled(false);
    }

    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        this.alert = Alert.create((Act)((Act)object));
        if (this.alert != null) {
            this.addComponent(this.createAlertType(this.alert, object, properties, context));
        }
        return super.apply(object, properties, parent, context);
    }

    protected ComponentSet createComponentSet(IMObject object, List<Property> properties, LayoutContext context) {
        ComponentSet set = super.createComponentSet(object, properties, context);
        if (this.alert != null) {
            ComponentState priority = this.getPriority(this.alert);
            int index = set.indexOf("alertType");
            if (index >= 0) {
                set.add(index + 1, priority);
            } else {
                set.add(priority);
            }
        }
        return set;
    }

    protected ComponentState createAlertType(Alert alert, IMObject object, PropertySet properties, LayoutContext context) {
        Property property = properties.get("alertType");
        ComponentState alertType = this.createAlertType(property, alert, object, context);
        if (!context.isEdit() && !alert.getAlertType().isActive()) {
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{alertType.getComponent(), LabelFactory.create((String)"imobject.deactivated", (String)"Selector.Deactivated")});
            alertType = new ComponentState((Component)row, property, alertType.getFocusGroup());
        }
        return alertType;
    }

    protected ComponentState createAlertType(Property property, Alert alert, IMObject object, LayoutContext context) {
        ComponentState alertType = this.createComponent(property, object, context);
        this.setAlertColour(alert, alertType.getComponent());
        return alertType;
    }

    protected void setAlertColour(Alert alert, Component component) {
        Color background;
        if (component instanceof TextField && (background = alert.getColour()) != null) {
            Color foreground = alert.getTextColour();
            component.setBackground(background);
            component.setForeground(foreground);
        }
    }

    private ComponentState getPriority(Alert alert) {
        this.priority.setText(alert.getPriority().getName());
        return new ComponentState((Component)this.priority, null, null, alert.getPriority().getDisplayName());
    }
}

