/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.CustomerPatientSMSTemplateSampler;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderEvaluator;

public class SMSAppointmentTemplateSampler
extends CustomerPatientSMSTemplateSampler {
    private final AppointmentReminderEvaluator evaluator;
    private final Property appointmentType;

    public SMSAppointmentTemplateSampler(Entity template, LayoutContext layoutContext) {
        super(template, layoutContext);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.evaluator = (AppointmentReminderEvaluator)ServiceHelper.getBean(AppointmentReminderEvaluator.class);
        this.appointmentType = SimpleProperty.newProperty().name("appointmentType").displayName(DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"appointmentType", (ArchetypeService)service)).type(Reference.class).archetypeRange(new String[]{"entity.appointmentType"}).build();
        this.appointmentType.addModifiableListener(modifiable -> this.evaluate());
    }

    @Override
    protected void layoutFields(ComponentGrid grid, FocusGroup group, LayoutContext context) {
        super.layoutFields(grid, group, context);
        DefaultIMObjectReferenceEditor selector = new DefaultIMObjectReferenceEditor(this.appointmentType, null, context);
        Label label = LabelFactory.text((String)this.appointmentType.getDisplayName());
        grid.add(new Component[]{label, selector.getComponent()});
        group.add(selector.getFocusGroup());
    }

    @Override
    protected String evaluate(Entity template, Context context) {
        Act act = (Act)IMObjectCreator.create((String)"act.customerAppointment");
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)act);
        bean.setTarget("customer", this.getCustomer());
        bean.setTarget("patient", this.getPatient());
        bean.setTarget("appointmentType", this.appointmentType.getReference());
        act.setActivityStartTime(new Date());
        act.setActivityEndTime(new Date());
        return this.evaluator.evaluate(template, act, context.getLocation(), context.getPractice());
    }
}

