/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.EditResultSetDialog;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.workspace.DocumentActActions;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.ChangePrinterDialog;
import org.openvpms.web.workspace.admin.template.DocumentTemplateEditDialog;
import org.openvpms.web.workspace.admin.template.VetCheckAdminDialog;
import org.openvpms.web.workspace.patient.vetcheck.VetCheckRules;

public class DocumentTemplateCRUDWindow
extends ResultSetCRUDWindow<Entity> {
    private final DocumentActActions documentActions = new DocumentActActions();
    static final String EXTERNAL_EDIT_ID = "button.externaledit";
    static final String VETCHECK = "button.vetcheck";
    static final String CHANGE_PRINTER = "button.changeprinter";

    public DocumentTemplateCRUDWindow(Archetypes<Entity> archetypes, Query<Entity> query, ResultSet<Entity> set, Context context, HelpContext help) {
        super(archetypes, query, set, context, help);
    }

    protected EditResultSetDialog<Entity> createEditResultSetDialog(Entity object, String title) {
        return new DocumentTemplateEditDialog(title, object, (ResultSet<Entity>)this.getResultSet(), (IMObjectActions<Entity>)this.getActions(), this.getContext(), this.getHelpContext());
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(EXTERNAL_EDIT_ID, this::onExternalEdit);
        VetCheckRules rules = (VetCheckRules)ServiceHelper.getBean(VetCheckRules.class);
        if (rules.isVetCheckEnabled()) {
            buttons.add(VETCHECK, this::onVetCheck);
        }
        buttons.add(CHANGE_PRINTER, this::onChangePrinter);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(EXTERNAL_EDIT_ID, enable && this.documentActions.canExternalEdit((Entity)this.getObject()));
    }

    private void onExternalEdit() {
        this.documentActions.externalEdit((Entity)this.getObject());
    }

    private void onVetCheck() {
        VetCheckAdminDialog dialog = new VetCheckAdminDialog(this.getHelpContext());
        dialog.show();
    }

    private void onChangePrinter() {
        ChangePrinterDialog.show(this.getHelpContext());
    }
}

