/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.customer.CustomerReferenceEditor;
import org.openvpms.web.component.im.edit.PatientReferenceEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.template.SMSTemplateSampler;

public abstract class CustomerPatientSMSTemplateSampler
extends SMSTemplateSampler {
    private final SimpleProperty customer;
    private final SimpleProperty patient;

    public CustomerPatientSMSTemplateSampler(Entity template, LayoutContext layoutContext) {
        super(template, layoutContext);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        this.customer = new SimpleProperty("customer", null, IMObjectReference.class, DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"customer", (ArchetypeService)service));
        this.patient = new SimpleProperty("patient", null, IMObjectReference.class, DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"patient", (ArchetypeService)service));
        this.customer.setArchetypeRange(new String[]{"party.customerperson"});
        this.patient.setArchetypeRange(new String[]{"party.patientpet"});
        ModifiableListener listener = modifiable -> this.evaluate();
        this.customer.addModifiableListener(listener);
        this.patient.addModifiableListener(listener);
    }

    @Override
    protected void layoutFields(ComponentGrid grid, FocusGroup group, LayoutContext context) {
        CustomerReferenceEditor customerSelector = new CustomerReferenceEditor((Property)this.customer, null, context);
        PatientReferenceEditor patientSelector = new PatientReferenceEditor((Property)this.patient, null, context);
        Label customerLabel = LabelFactory.text((String)this.customer.getDisplayName());
        Label patientLabel = LabelFactory.text((String)this.patient.getDisplayName());
        grid.add(new Component[]{customerLabel, customerSelector.getComponent(), patientLabel, patientSelector.getComponent()});
        group.add(customerSelector.getFocusGroup());
        group.add(patientSelector.getFocusGroup());
    }

    protected Reference getCustomer() {
        return this.customer.getReference();
    }

    protected Reference getPatient() {
        return this.patient.getReference();
    }
}

