/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.template;

import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;

public class AbstractDocumentTemplateTableModel
extends DescriptorTableModel<Entity> {
    private final String[] nodes;
    private final TemplateHelper templateHelper;
    private int contentIndex;
    private static final String[] ARCHETYPES = new String[]{"entity.documentTemplate"};

    protected AbstractDocumentTemplateTableModel(String[] nodes, LayoutContext context, boolean active) {
        super(context);
        this.nodes = active ? nodes : (String[])ArrayUtils.removeElement((Object[])nodes, (Object)"active");
        this.templateHelper = new TemplateHelper(this.getService());
        this.setTableColumnModel(this.createColumnModel(ARCHETYPES, context));
    }

    protected String[] getNodeNames() {
        return this.nodes;
    }

    protected Object getValue(Entity object, TableColumn column, int row) {
        if (column.getModelIndex() == this.contentIndex) {
            return this.getContentName(object);
        }
        return super.getValue((IMObject)object, column, row);
    }

    protected Object getValue(Entity object, DescriptorTableColumn column, int row) {
        Object result = null;
        if ("type".equals(column.getName())) {
            List values = column.getValues((IMObject)object);
            if (values != null && !values.isEmpty()) {
                result = ((IMObject)values.get(0)).getName();
            }
        } else {
            result = super.getValue((IMObject)object, column, row);
        }
        return result;
    }

    protected TableColumnModel createColumnModel(String[] shortNames, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(shortNames, context);
        this.contentIndex = this.getNextModelIndex((TableColumnModel)model);
        model.addColumn(AbstractDocumentTemplateTableModel.createTableColumn((int)this.contentIndex, (String)"document.template.content"));
        return model;
    }

    private String getContentName(Entity object) {
        return this.templateHelper.getFileName(object);
    }
}

