/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.openoffice;

import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.report.openoffice.OpenOfficeConfig;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

public class OpenOfficeStatus {
    private final OpenOfficeService officeService;
    private final ArchetypeService service;
    private final SimpleProperty home;
    private final SimpleProperty ports;
    private final SimpleProperty maxTasks;
    private final SimpleProperty running;
    private Component component;

    public OpenOfficeStatus(OpenOfficeService officeService, ArchetypeService service) {
        this.officeService = officeService;
        this.service = service;
        this.home = new SimpleProperty("home", null, String.class, this.getDisplayName("path"), true);
        this.ports = new SimpleProperty("ports", null, String.class, this.getDisplayName("ports"), true);
        this.maxTasks = new SimpleProperty("maxTasks", null, Integer.class, this.getDisplayName("maxTasksPerProcess"), true);
        this.running = new SimpleProperty("running", null, String.class, Messages.get((String)"admin.system.openoffice.running"), true);
    }

    public Property getHome() {
        return this.home;
    }

    public Property getPorts() {
        return this.ports;
    }

    public Property getMaxTasksPerProcess() {
        return this.maxTasks;
    }

    public Property getRunning() {
        return this.running;
    }

    public Component getComponent() {
        if (this.component == null) {
            ComponentGrid grid = new ComponentGrid();
            grid.add(new Component[]{LabelFactory.text((String)this.getDisplayName("path")), BoundTextComponentFactory.create((Property)this.home, (int)50)});
            grid.add(new Component[]{LabelFactory.text((String)this.getDisplayName("ports")), BoundTextComponentFactory.create((Property)this.ports, (int)20)});
            grid.add(new Component[]{LabelFactory.text((String)this.getDisplayName("maxTasksPerProcess")), BoundTextComponentFactory.createNumeric((Property)this.maxTasks, (int)5)});
            grid.add(new Component[]{LabelFactory.create((String)"admin.system.openoffice.running"), BoundTextComponentFactory.create((Property)this.running, (int)5)});
            this.component = grid.createGrid();
            this.refresh();
        }
        return this.component;
    }

    public void refresh() {
        OpenOfficeConfig config = this.officeService.getConfig();
        this.home.setValue((Object)config.getPath());
        this.ports.setValue((Object)StringUtils.join((Iterable)config.getPorts(), (String)", "));
        this.maxTasks.setValue((Object)config.getMaxTasksPerProcess());
        this.running.setValue((Object)Messages.format((String)"yesOrNo", (Object[])new Object[]{this.officeService.isRunning() ? 1 : 0}));
    }

    private String getDisplayName(String node) {
        return DescriptorHelper.getDisplayName((String)"entity.globalSettingsOpenOffice", (String)node, (ArchetypeService)this.service);
    }
}

