/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.firewall;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.property.AbstractEditor;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetImpl;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

class FirewallEntryEditor
extends AbstractEditor {
    private final Editors editors;
    private final SimpleProperty address = new SimpleProperty("address", String.class);
    private final SimpleProperty active = new SimpleProperty("active", Boolean.class);
    private final SimpleProperty description = new SimpleProperty("description", String.class);
    private final SimpleProperty range = new SimpleProperty("range", String.class);
    private final Component component;

    public FirewallEntryEditor(LayoutContext context) {
        this(null, true, null, context);
    }

    public FirewallEntryEditor(FirewallEntry entry, LayoutContext context) {
        this(entry.getAddress(), entry.isActive(), entry.getDescription(), context);
    }

    public FirewallEntryEditor(String address, boolean active, String description, LayoutContext context) {
        this.address.setValue((Object)address);
        this.active.setValue((Object)active);
        this.description.setValue((Object)description);
        this.updateRange();
        this.component = this.createComponent(context);
        this.editors = this.createEditors();
        this.address.addModifiableListener(modifiable -> this.updateRange());
    }

    public Component getComponent() {
        return this.component;
    }

    public String getAddress() {
        return this.address.getString();
    }

    public boolean getActive() {
        return this.active.getBoolean();
    }

    public String getDescription() {
        return this.description.getString();
    }

    public FirewallEntry getEntry() {
        return new FirewallEntry(this.address.getString(), this.active.getBoolean(), this.description.getString());
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.address.getString()) && this.active.getBoolean() && StringUtils.isEmpty((CharSequence)this.description.getString());
    }

    public boolean isModified() {
        return super.isModified() || this.editors.isModified();
    }

    public void clearModified() {
        super.clearModified();
        this.editors.clearModified();
    }

    protected boolean doValidation(Validator validator) {
        return this.editors.validate(validator) && this.validateAddress(validator);
    }

    static String getRange(String address) {
        String result;
        try {
            IPAddressString parser = new IPAddressString(address);
            IPAddress block = parser.toAddress().toPrefixBlock();
            result = block.getLower().equals((Object)block.getUpper()) ? block.getLower().withoutPrefixLength().toString() : block.getLower().withoutPrefixLength() + " - " + block.getUpper().withoutPrefixLength();
        }
        catch (AddressStringException exception) {
            result = exception.getMessage();
        }
        return result;
    }

    private void updateRange() {
        if (this.validateAddress((Validator)new DefaultValidator())) {
            this.range.setValue((Object)FirewallEntryEditor.getRange(this.getAddress()));
        } else {
            this.range.setValue(null);
        }
    }

    private boolean validateAddress(Validator validator) {
        boolean valid = this.address.validate(validator);
        if (valid) {
            IPAddressStringParameters params = new IPAddressStringParameters.Builder().allowIPv4(true).allowIPv6(true).allow_inet_aton(false).allowEmpty(false).allowWildcardedSeparator(false).allowMask(true).toParams();
            IPAddressString string = new IPAddressString(this.address.getString(), params);
            try {
                string.toAddress();
                new IpAddressMatcher(this.address.getString());
            }
            catch (Exception exception) {
                validator.add((Modifiable)this, exception.getMessage());
                valid = false;
            }
        }
        return valid;
    }

    private Editors createEditors() {
        PropertySetImpl set = new PropertySetImpl(new Property[]{this.address, this.active, this.description});
        return new Editors((PropertySet)set, this.getListeners());
    }

    private Component createComponent(LayoutContext context) {
        this.address.setRequired(true);
        this.description.setMaxLength(20);
        this.range.setReadOnly(true);
        this.range.setDisplayName(Messages.get((String)"admin.system.firewall.range"));
        ComponentGrid grid = new ComponentGrid();
        IMObjectComponentFactory factory = context.getComponentFactory();
        ComponentState addressField = new ComponentState(factory.create((Property)this.address), (Property)this.address);
        ComponentState activeField = new ComponentState(factory.create((Property)this.active), (Property)this.active);
        ComponentState descriptionField = new ComponentState(factory.create((Property)this.description), (Property)this.description);
        grid.add(new ComponentState[]{addressField});
        grid.add(new ComponentState[]{activeField});
        grid.add(new ComponentState[]{descriptionField});
        grid.add(new ComponentState[]{new ComponentState(factory.create((Property)this.range), (Property)this.range)});
        FocusGroup focusGroup = this.getFocusGroup();
        focusGroup.add(addressField.getComponent());
        focusGroup.add(activeField.getComponent());
        focusGroup.add(descriptionField.getComponent());
        return grid.createGrid();
    }
}

