/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.firewall;

import java.util.List;
import org.openvpms.archetype.rules.party.Contacts;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.business.dao.im.security.IUserDAO;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.firewall.AddressCoverageValidator;
import org.openvpms.web.workspace.admin.system.firewall.AllowedAddressCollectionEditor;

public class FirewallEditor
extends AbstractIMObjectEditor {
    private final PracticeService practiceService = (PracticeService)ServiceHelper.getBean(PracticeService.class);
    private final Contacts contacts = new Contacts((ArchetypeService)this.getService());
    private final FirewallSettings settings;
    private final AddressCoverageValidator coverage;
    private final AllowedAddressCollectionEditor allowedAddresses;

    public FirewallEditor(Entity object, IMObject parent, LayoutContext layoutContext) {
        super((IMObject)object, parent, layoutContext);
        this.settings = new FirewallSettings(object, (ArchetypeService)this.getService());
        this.allowedAddresses = new AllowedAddressCollectionEditor(this.settings, this.getLayoutContext());
        this.coverage = new AddressCoverageValidator((SessionMonitor)ServiceHelper.getBean(SessionMonitor.class), (IUserDAO)ServiceHelper.getBean(IUserDAO.class), (ArchetypeService)this.getService());
        this.getEditors().add((Editor)this.allowedAddresses);
    }

    public IMObjectEditor newInstance() {
        return new FirewallEditor((Entity)this.reload(this.getObject()), this.getParent(), this.getLayoutContext());
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        IMObjectLayoutStrategy strategy = super.createLayoutStrategy();
        strategy.addComponent(new ComponentState(this.allowedAddresses.getComponent(), this.getProperty("allowed0"), this.allowedAddresses.getFocusGroup()));
        return strategy;
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateAddressCoverage(validator) && this.validateMultifactorAuthentication(validator);
    }

    private boolean validateAddressCoverage(Validator validator) {
        List<String> activeAddresses;
        AddressCoverageValidator.Excluded uncovered;
        boolean result = true;
        if (this.settings.getAccessType() != FirewallSettings.AccessType.UNRESTRICTED && (uncovered = this.coverage.getFirstExcludedAddress(activeAddresses = this.allowedAddresses.getActiveAddresses(), this.settings.getAccessType())) != null) {
            result = false;
            validator.add((Modifiable)this, Messages.format((String)"admin.system.firewall.addressnotcovered", (Object[])new Object[]{this.getProperty("allowed0").getDisplayName(), uncovered.getAddress(), uncovered.getUser()}));
        }
        return result;
    }

    private boolean validateMultifactorAuthentication(Validator validator) {
        Party practice;
        boolean result = true;
        Property mfa = this.getProperty("enableMfa");
        if (mfa.getBoolean() && ((practice = this.practiceService.getPractice()) == null || this.contacts.getEmail(practice) == null || this.practiceService.getMailServer() == null)) {
            validator.add((Modifiable)mfa, Messages.get((String)"admin.system.firewall.emailnotconfigured"));
            result = false;
        }
        return result;
    }
}

