/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.firewall;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.security.FirewallEntry;
import org.openvpms.archetype.rules.security.FirewallSettings;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.edit.Editors;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.AbstractEditor;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.system.firewall.FirewallEntryEditor;

class AllowedAddressCollectionEditor
extends AbstractEditor {
    private final FirewallSettings settings;
    private final LayoutContext layoutContext;
    private final Editors editors;
    private final List<FirewallEntryEditor> addresses = new ArrayList<FirewallEntryEditor>();
    private final Component component;
    private final PagedIMTable<FirewallEntryEditor> table;
    private final Component editorContainer = ColumnFactory.create();
    private final ButtonRow buttons;
    private final ModifiableListener currentListener;
    private FirewallEntryEditor current;
    private static final String ADD_ID = "button.add";
    private static final String DELETE_ID = "button.delete";

    public AllowedAddressCollectionEditor(FirewallSettings settings, LayoutContext layoutContext) {
        this.settings = settings;
        this.layoutContext = layoutContext;
        this.editors = new Editors(this.getListeners());
        this.currentListener = modifiable -> this.changed();
        for (FirewallEntry entry : settings.getAllowedAddresses()) {
            FirewallEntryEditor addressEditor = new FirewallEntryEditor(entry, layoutContext);
            this.addresses.add(addressEditor);
            this.editors.add((Editor)addressEditor);
        }
        FocusGroup group = this.getFocusGroup();
        this.buttons = new ButtonRow(group);
        this.buttons.addButton(ADD_ID, this::onAdd);
        this.buttons.addButton(DELETE_ID, this::onDelete);
        this.table = new PagedIMTable((IMTableModel)new AddressTableModel());
        this.table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AllowedAddressCollectionEditor.this.onSelected();
            }
        });
        this.component = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{this.buttons, this.table.getComponent(), this.editorContainer});
        this.refreshTable();
        this.enableDelete();
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isModified() {
        return super.isModified() || this.editors.isModified() || this.current == null || this.current.isModified();
    }

    public void clearModified() {
        super.clearModified();
        this.editors.clearModified();
        if (this.current != null) {
            this.current.clearModified();
        }
    }

    public boolean isValid() {
        return super.isValid() && this.editors.isValid() && (this.current == null || this.current.isEmpty() || this.current.isValid());
    }

    public List<String> getActiveAddresses() {
        return this.addresses.stream().filter(FirewallEntryEditor::getActive).map(FirewallEntryEditor::getAddress).collect(Collectors.toList());
    }

    protected void resetValid(boolean descendants) {
        super.resetValid(descendants);
        if (descendants) {
            this.editors.resetValid();
            if (this.current != null) {
                this.current.resetValid();
            }
        }
    }

    protected boolean doValidation(Validator validator) {
        boolean result = true;
        if (this.current != null) {
            result = this.addCurrentEdits(validator);
        }
        if (result) {
            result = this.editors.validate(validator);
        }
        if (result) {
            result = this.populateAllowedAddressesSettings(validator);
        }
        return result;
    }

    private void refreshTable() {
        ListResultSet set = new ListResultSet(this.addresses, 10);
        this.table.setResultSet((ResultSet)set);
    }

    private void enableDelete() {
        boolean enableDelete = this.current != null || this.table.getSelected() != null;
        this.buttons.getButtons().setEnabled(DELETE_ID, enableDelete);
    }

    private boolean populateAllowedAddressesSettings(Validator validator) {
        boolean result;
        List entries = this.addresses.stream().map(FirewallEntryEditor::getEntry).collect(Collectors.toList());
        try {
            this.settings.setAllowedAddresses(entries);
            result = true;
        }
        catch (IllegalArgumentException exception) {
            result = false;
            validator.add((Modifiable)this, Messages.get((String)"admin.system.firewall.toomanyaddresses"));
        }
        return result;
    }

    private void onAdd() {
        if (this.addCurrentEdits((Validator)new DefaultValidator())) {
            this.editorContainer.removeAll();
            this.setEditor(new FirewallEntryEditor(this.layoutContext));
            this.enableDelete();
        }
    }

    private void onDelete() {
        FirewallEntryEditor editor = this.current;
        if (editor == null) {
            editor = (FirewallEntryEditor)((Object)this.table.getSelected());
        }
        if (editor != null) {
            this.editors.remove((Editor)editor);
            editor.removeModifiableListener(this.currentListener);
            this.getFocusGroup().remove(editor.getFocusGroup());
            if (this.addresses.remove((Object)editor)) {
                this.refreshTable();
            }
            this.current = null;
            this.editorContainer.removeAll();
            this.changed();
        }
        this.enableDelete();
    }

    private void onSelected() {
        FirewallEntryEditor selected = (FirewallEntryEditor)((Object)this.table.getSelected());
        if (this.addCurrentEdits((Validator)new DefaultValidator())) {
            this.editorContainer.removeAll();
            if (selected != null) {
                this.setEditor(selected);
            }
            this.enableDelete();
        }
    }

    private void setEditor(FirewallEntryEditor editor) {
        FocusGroup focusGroup = this.getFocusGroup();
        if (this.current != null) {
            this.current.removeModifiableListener(this.currentListener);
            focusGroup.remove(this.current.getFocusGroup());
        }
        this.current = editor;
        this.current.addModifiableListener(this.currentListener);
        focusGroup.add(editor.getFocusGroup());
        this.editorContainer.add(this.current.getComponent());
        this.current.getFocusGroup().setFocus();
    }

    private boolean addCurrentEdits(Validator validator) {
        boolean valid = true;
        if (this.current != null) {
            if (this.current.isEmpty()) {
                this.editors.remove((Editor)this.current);
                this.addresses.remove((Object)this.current);
                this.refreshTable();
                this.changed();
            } else {
                valid = this.current.validate(validator);
                if (valid) {
                    valid = this.validateUnique(validator);
                }
                if (valid) {
                    if (!this.editors.getEditors().contains((Object)this.current)) {
                        this.editors.add((Editor)this.current);
                    }
                    if (!this.addresses.contains((Object)this.current)) {
                        this.addresses.add(this.current);
                    }
                    if (this.current.isModified()) {
                        this.refreshTable();
                        this.current.clearModified();
                    }
                }
            }
        }
        return valid;
    }

    private boolean validateUnique(Validator validator) {
        boolean valid = true;
        String address = this.current.getAddress();
        for (FirewallEntryEditor existing : this.addresses) {
            if (existing == this.current || !address.equals(existing.getAddress())) continue;
            valid = false;
            validator.add((Modifiable)this.current, Messages.format((String)"admin.system.firewall.duplicate", (Object[])new Object[]{address}));
            break;
        }
        return valid;
    }

    private void changed() {
        this.setModified();
        this.resetValid();
        this.notifyListeners();
    }

    private static class AddressTableModel
    extends AbstractIMTableModel<FirewallEntryEditor> {
        private static final int ADDRESS_INDEX = 0;
        private static final int ACTIVE_INDEX = 1;
        private static final int DESCRIPTION_INDEX = 2;
        private static final int RANGE_INDEX = 3;

        public AddressTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(AddressTableModel.createTableColumn((int)0, (String)"admin.system.firewall.address"));
            model.addColumn(AddressTableModel.createTableColumn((int)1, (String)"table.imobject.active"));
            model.addColumn(AddressTableModel.createTableColumn((int)2, (String)"table.imobject.description"));
            model.addColumn(AddressTableModel.createTableColumn((int)3, (String)"admin.system.firewall.range"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return new SortConstraint[0];
        }

        protected Object getValue(FirewallEntryEditor object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getAddress();
                    break;
                }
                case 1: {
                    result = this.getCheckBox(object.getActive());
                    break;
                }
                case 2: {
                    result = object.getDescription();
                    break;
                }
                case 3: {
                    result = FirewallEntryEditor.getRange(object.getAddress());
                }
            }
            return result;
        }
    }
}

