/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.logging.LoggingConfig;

public class LoggingDialog
extends ModalDialog {
    private final LoggingConfig config;
    private final PagedIMTable<Pair<String, Level>> table;
    private final Property category = SimpleProperty.newProperty().name("category").type(String.class).displayNameKey("admin.system.logging.category").build();
    private final Property level = SimpleProperty.newProperty().name("level").type(Level.class).required().value((Object)Level.INFO).displayNameKey("admin.system.logging.level").build();
    private final Column container = new Column();
    private static final String RESET_ID = "button.reset";

    public LoggingDialog() {
        super(Messages.get((String)"admin.system.diagnostic.logging.title"), "MessageDialog", new String[]{"close", RESET_ID});
        this.config = (LoggingConfig)ServiceHelper.getBean(LoggingConfig.class);
        this.table = new PagedIMTable((IMTableModel)new Model());
        this.table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                Pair selected = (Pair)LoggingDialog.this.table.getSelected();
                if (selected != null) {
                    LoggingDialog.this.category.setValue(selected.getLeft());
                    LoggingDialog.this.level.setValue(selected.getRight());
                }
            }
        });
        this.resize("LoggingDialog.size");
    }

    protected void onButton(String button) {
        if (RESET_ID.equals(button)) {
            this.onReset();
        } else {
            super.onButton(button);
        }
    }

    protected void doLayout() {
        this.refresh();
        Object[] levels = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL};
        SelectField field = BoundSelectFieldFactory.create((Property)this.level, (ListModel)new DefaultListModel(levels));
        Button add = ButtonFactory.create((String)"button.add", this::onAdd);
        Button remove = ButtonFactory.create((String)"button.delete", this::onRemove);
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"admin.system.diagnostic.logging.category"), BoundTextComponentFactory.create((Property)this.category, (int)70), field, add, remove});
        Column column = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{row, this.container});
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{column}));
    }

    private void onAdd() {
        String c = this.category.getString();
        Level l = (Level)this.level.getValue();
        if (c != null && l != null) {
            this.config.add(c, l);
            this.category.setValue(null);
            this.refresh();
        }
    }

    private void onRemove() {
        String c = this.category.getString();
        if (c != null) {
            this.config.remove(c);
            this.category.setValue(null);
            this.refresh();
        }
    }

    private void refresh() {
        int page = this.table.getPage();
        SortConstraint[] sort = this.table.getResultSet() != null ? this.table.getResultSet().getSortConstraints() : null;
        ArrayList list = new ArrayList();
        Map<String, Level> categories = this.config.getCategories();
        if (sort == null) {
            categories = new TreeMap<String, Level>(categories);
        }
        categories.forEach((key, value) -> list.add(Pair.of((Object)key, (Object)value)));
        ListResultSet<Pair<String, Level>> set = new ListResultSet<Pair<String, Level>>(list, 15){

            public void sort(SortConstraint[] sort) {
                IMObjectSorter.sort((List)this.getObjects(), (SortConstraint[])sort, input -> input);
                super.sort(sort);
            }
        };
        if (sort != null) {
            set.sort(sort);
        }
        this.table.setResultSet((ResultSet)set);
        if (this.table.getPage() != page) {
            this.table.getNavigator().setPage(page);
        }
        this.container.removeAll();
        if (set.getResults() != 0) {
            this.container.add(this.table.getComponent());
        } else {
            Label label = LabelFactory.create((String)"admin.system.diagnostic.logging.none", (String)"bold");
            label.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
            Column wrapper = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{label});
            wrapper.setLayoutData((LayoutData)ColumnFactory.layout((Alignment)Alignment.ALIGN_CENTER));
            this.container.add((Component)wrapper);
        }
    }

    private void onReset() {
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().titleKey("admin.system.diagnostic.logging.title", new Object[0])).messageKey("admin.system.diagnostic.logging.reset", new Object[0])).yesNo()).yes(() -> {
            this.config.reset();
            this.refresh();
        })).show();
    }

    private static class Model
    extends AbstractIMTableModel<Pair<String, Level>> {
        private static final int CATEGORY_INDEX = 0;
        private static final int LEVEL_INDEX = 1;

        public Model() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(Model.createTableColumn((int)0, (String)"admin.system.diagnostic.logging.category"));
            model.addColumn(Model.createTableColumn((int)1, (String)"admin.system.diagnostic.logging.level"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            if (column == 0) {
                return new SortConstraint[]{new VirtualNodeSortConstraint("category", ascending, object -> {
                    Pair pair = (Pair)object;
                    return pair.getLeft();
                })};
            }
            if (column == 1) {
                return new SortConstraint[]{new VirtualNodeSortConstraint("level", ascending, object -> {
                    Pair pair = (Pair)object;
                    return pair.getRight();
                })};
            }
            return null;
        }

        protected Object getValue(Pair<String, Level> object, TableColumn column, int row) {
            int index = column.getModelIndex();
            if (index == 0) {
                return object.getLeft();
            }
            if (index == 1) {
                return object.getRight();
            }
            return null;
        }
    }
}

