/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class ThreadViewer
extends AbstractDiagnosticTab {
    private String snapshot;

    ThreadViewer() {
        super("admin.system.diagnostic.thread");
    }

    @Override
    public Document getDocument() {
        Document result = null;
        String data = this.getData(false);
        if (data != null) {
            result = this.toText("threads.txt", data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        Label result = null;
        String data = this.getData(true);
        if (data != null) {
            result = LabelFactory.preformatted((String)data);
        }
        return result;
    }

    private String getData(boolean refresh) {
        if (this.snapshot == null || refresh) {
            try {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                ThreadInfo[] infos = bean.dumpAllThreads(true, true);
                StringBuilder builder = new StringBuilder();
                for (ThreadInfo info : infos) {
                    this.dump(info, builder);
                    builder.append(info);
                    builder.append('\n');
                }
                this.snapshot = builder.toString();
            }
            catch (Throwable exception) {
                this.snapshot = null;
                ErrorHelper.show((Throwable)exception);
            }
        }
        return this.snapshot;
    }

    private void dump(ThreadInfo info, StringBuilder sb) {
        LockInfo[] locks;
        int i;
        sb.append("\"").append(info.getThreadName()).append("\"").append(" Id=").append(info.getThreadId()).append(" ").append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (i = 0; i < info.getStackTrace().length; ++i) {
            StackTraceElement ste = info.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && info.getLockInfo() != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(info.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : info.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo);
                sb.append('\n');
            }
        }
        if (i < info.getStackTrace().length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = info.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
    }
}

