/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableModel;
import nextapp.echo2.app.table.TableModel;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.version.Version;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.DefaultTableHeaderRenderer;
import org.openvpms.web.echo.table.KeyTable;
import org.openvpms.web.workspace.admin.system.diagnostics.AbstractDiagnosticTab;

class PropertiesViewer
extends AbstractDiagnosticTab {
    private String[][] snapshot;
    private static final String[] COLUMNS = new String[]{"Name", "Value"};

    PropertiesViewer() {
        super("admin.system.diagnostic.property");
    }

    @Override
    public Document getDocument() {
        Document result = null;
        String[][] data = this.getData(false);
        if (data != null) {
            result = this.toCSV("properties.csv", COLUMNS, data);
        }
        return result;
    }

    @Override
    protected Component getContent() {
        KeyTable result = null;
        Object[][] data = this.getData(true);
        if (data != null) {
            DefaultTableModel model = new DefaultTableModel(data, (Object[])COLUMNS);
            KeyTable table = TableFactory.create((TableModel)model);
            table.setDefaultHeaderRenderer(DefaultTableHeaderRenderer.DEFAULT);
            result = table;
        }
        return result;
    }

    private String[][] getData(boolean refresh) {
        if (this.snapshot == null || refresh) {
            Properties properties = System.getProperties();
            TreeMap<String, String> map = new TreeMap<String, String>();
            for (String name : properties.stringPropertyNames()) {
                map.put(name, properties.getProperty(name));
            }
            this.snapshot = new String[map.size() + 1][2];
            this.snapshot[0][0] = "openvpms.version";
            this.snapshot[0][1] = Version.VERSION + " (" + Version.REVISION + ")";
            int i = 1;
            for (Map.Entry next : map.entrySet()) {
                this.snapshot[i][0] = (String)next.getKey();
                this.snapshot[i][1] = (String)next.getValue();
                ++i;
            }
        }
        return this.snapshot;
    }
}

