/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public class LogReader {
    private final String path;
    private final int maxLines;
    private final byte[] buffer = new byte[8192];
    private final ArrayList<PageState> pages = new ArrayList();
    private long length = -1L;

    LogReader(File file, int maxLines) {
        this(file.getPath(), maxLines);
    }

    LogReader(String path, int maxLines) {
        this.path = path;
        this.maxLines = maxLines;
    }

    public String getPath() {
        return this.path;
    }

    public long getLength() throws IOException {
        long result;
        try (RandomAccessFile file = new RandomAccessFile(this.path, "r");){
            result = this.checkLength(file);
        }
        return result;
    }

    public Page read(int page) throws IOException {
        Page result = null;
        Page current = null;
        try (RandomAccessFile file = new RandomAccessFile(this.path, "r");){
            boolean done = false;
            while (!done) {
                current = page < this.pages.size() ? this.reread(file, page, this.pages.get(page)) : this.readNext(file);
                if (current != null && current.getPage() != page && !current.isPartial()) continue;
                done = true;
            }
        }
        if (current != null && current.getPage() == page) {
            result = current;
        }
        return result;
    }

    public Page readLast() throws IOException {
        Page result = null;
        try (RandomAccessFile file = new RandomAccessFile(this.path, "r");){
            Page page;
            while ((page = this.readNext(file)) != null && !(result = page).isPartial()) {
            }
        }
        return result;
    }

    private Page reread(RandomAccessFile file, int page, PageState state) throws IOException {
        return this.readFromOffset(file, page, state.startOffset, state.first);
    }

    private Page readNext(RandomAccessFile file) throws IOException {
        Page last;
        int lastPage;
        PageState state;
        Object result = this.pages.isEmpty() ? this.readAtCurrentPosition(file, 0, 0) : ((state = this.pages.get(lastPage = this.pages.size() - 1)).partial ? ((last = this.reread(file, lastPage, state)) == null ? null : (last.isPartial() ? last : this.readNext(file, last.state))) : this.readNext(file, state));
        return result;
    }

    private Page readFromOffset(RandomAccessFile file, int page, long offset, int first) throws IOException {
        Page result = null;
        if (this.seek(file, offset)) {
            result = this.readAtCurrentPosition(file, page, first);
        }
        return result;
    }

    private Page readAtCurrentPosition(RandomAccessFile file, int page, int first) throws IOException {
        long startOffset;
        ArrayList<String> lines = new ArrayList<String>();
        Reader reader = new Reader(file, this.buffer);
        long endOffset = startOffset = reader.getFilePointer();
        for (int i = 0; i < this.maxLines && !reader.eof(); ++i) {
            String line = reader.readLine();
            if (line != null) {
                lines.add(line);
            }
            endOffset = reader.getFilePointer();
        }
        boolean partial = reader.eof() || lines.size() != this.maxLines;
        PageState state = new PageState(page, startOffset, endOffset, first, lines.size(), partial);
        if (page < this.pages.size()) {
            this.pages.set(page, state);
        } else {
            this.pages.add(state);
        }
        return new Page(lines, state);
    }

    private Page readNext(RandomAccessFile file, PageState state) throws IOException {
        return this.readFromOffset(file, state.page + 1, state.endOffset, state.first + state.count);
    }

    private boolean seek(RandomAccessFile file, long offset) throws IOException {
        boolean result = false;
        long newLength = this.checkLength(file);
        if (newLength > offset) {
            file.seek(offset);
            result = true;
        }
        return result;
    }

    private long checkLength(RandomAccessFile file) throws IOException {
        long newLength = file.length();
        if (this.length != -1L && newLength < this.length) {
            this.pages.clear();
        }
        this.length = newLength;
        return this.length;
    }

    private static final class PageState {
        private final int page;
        private final long startOffset;
        private final long endOffset;
        private final int first;
        private final int count;
        private final boolean partial;

        PageState(int page, long startOffset, long endOffset, int first, int count, boolean partial) {
            this.page = page;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.first = first;
            this.count = count;
            this.partial = partial;
        }
    }

    private static class Reader {
        private final RandomAccessFile file;
        private final byte[] buffer;
        private int count;
        private int index;
        private long pointer;
        private boolean eof;

        Reader(RandomAccessFile file, byte[] buffer) throws IOException {
            this.file = file;
            this.buffer = buffer;
            this.pointer = file.getFilePointer();
        }

        String readLine() throws IOException {
            StringBuilder line = new StringBuilder();
            int ch = -1;
            this.eof = false;
            boolean eol = false;
            block4: while (!eol) {
                ch = this.readNext();
                switch (ch) {
                    case -1: 
                    case 10: {
                        eol = true;
                        continue block4;
                    }
                    case 13: {
                        eol = true;
                        long pos = this.pointer;
                        int currentIndex = this.index;
                        if (this.readNext() == 10) continue block4;
                        this.pointer = pos;
                        if (currentIndex > this.index) {
                            this.index = this.count;
                            continue block4;
                        }
                        this.index = currentIndex;
                        continue block4;
                    }
                }
                line.append((char)ch);
            }
            this.eof = ch == -1;
            return this.eof && line.length() == 0 ? null : line.toString();
        }

        boolean eof() {
            return this.eof;
        }

        long getFilePointer() {
            return this.pointer;
        }

        private int readNext() throws IOException {
            int ch;
            if (this.index == this.count) {
                this.index = 0;
                this.count = this.file.read(this.buffer);
                ch = this.count <= 0 ? -1 : this.buffer[this.index] & 0xFF;
            } else {
                ch = this.buffer[this.index] & 0xFF;
            }
            if (ch != -1) {
                ++this.pointer;
                ++this.index;
            }
            return ch;
        }
    }

    public static class Search {
        private final String criteria;
        private final boolean caseSensitive;

        public Search(String criteria, boolean caseSensitive) {
            this.criteria = caseSensitive ? criteria : criteria.toLowerCase();
            this.caseSensitive = caseSensitive;
        }

        public boolean matches(String line) {
            return this.indexOf(line, 0) != -1;
        }

        public int indexOf(String line, int fromIndex) {
            if (!this.caseSensitive) {
                line = line.toLowerCase();
            }
            return line.indexOf(this.criteria, fromIndex);
        }

        public int length() {
            return this.criteria.length();
        }
    }

    public static class Page {
        private final List<String> lines;
        private final PageState state;

        Page(List<String> lines, PageState state) {
            this.lines = lines;
            this.state = state;
        }

        public int getPage() {
            return this.state.page;
        }

        public boolean isPartial() {
            return this.state.partial;
        }

        public int getFirstLine() {
            return this.state.first;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public boolean contains(Search search) {
            for (String line : this.lines) {
                if (!search.matches(line)) continue;
                return true;
            }
            return false;
        }
    }
}

