/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.diagnostics;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import org.openvpms.archetype.rules.doc.TemporaryDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.diagnostics.DiagnosticTab;

abstract class AbstractDiagnosticTab
implements DiagnosticTab {
    private final String name;
    private Component component;

    AbstractDiagnosticTab(String name) {
        this.name = Messages.get((String)name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.refresh();
        }
        return this.component;
    }

    @Override
    public void refresh() {
        Component content = this.getContent();
        this.component = !(content instanceof SplitPane) ? ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{content}) : content;
    }

    protected abstract Component getContent();

    protected Document toDocument(String fileName, byte[] content, int length, String mimeType) {
        TemporaryDocumentHandler handler = new TemporaryDocumentHandler((ArchetypeService)ServiceHelper.getArchetypeService());
        return handler.create(fileName, content, mimeType, length);
    }

    Document toCSV(String fileName, String[] columns, String[][] data) {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer);
        csv.writeNext(columns);
        for (String[] entry : data) {
            csv.writeNext(entry);
        }
        return this.toCSV(fileName, writer);
    }

    Document toCSV(String fileName, String[] columns, List<String[]> data) {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer);
        csv.writeNext(columns);
        csv.writeAll(data);
        return this.toCSV(fileName, writer);
    }

    Document toText(String fileName, String text) {
        if (text == null) {
            text = "";
        }
        return this.toDocument(fileName, text, "text/plain");
    }

    private Document toCSV(String fileName, StringWriter writer) {
        String string = writer.getBuffer().toString();
        return this.toDocument(fileName, string, "text/csv");
    }

    private Document toDocument(String fileName, String text, String mimeType) {
        byte[] buffer = text.getBytes(StandardCharsets.UTF_8);
        return this.toDocument(fileName, buffer, buffer.length, mimeType);
    }
}

