/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public class Memory {
    private final boolean showAllocated;
    private final SimpleProperty totalMemory = new SimpleProperty("totalmemory", null, String.class, Messages.get((String)"admin.system.cache.totalmemory"), true);
    private final SimpleProperty freeMemory = new SimpleProperty("freememory", null, String.class, Messages.get((String)"admin.system.cache.freememory"), true);
    private final SimpleProperty memoryUse = new SimpleProperty("memoryuse", null, String.class, Messages.get((String)"admin.system.cache.memoryuse"), true);
    private final SimpleProperty allocatedTotalMemory = new SimpleProperty("allocatedtotal", null, String.class, Messages.get((String)"admin.system.cache.allocatedtotal"), true);
    private final SimpleProperty allocatedFreeMemory = new SimpleProperty("allocatedtotal", null, String.class, Messages.get((String)"admin.system.cache.allocatedfree"), true);

    public Memory() {
        this(false);
    }

    public Memory(boolean showAllocated) {
        this.showAllocated = showAllocated;
    }

    public Component getComponent() {
        TextField total = this.createField((Property)this.totalMemory);
        TextField free = this.createField((Property)this.freeMemory);
        TextField use = this.createField((Property)this.memoryUse);
        TextField allocatedTotal = this.createField((Property)this.allocatedTotalMemory);
        TextField allocatedFree = this.createField((Property)this.allocatedFreeMemory);
        this.refresh();
        ComponentGrid grid = new ComponentGrid();
        grid.add(new ComponentState[]{new ComponentState((Component)total, (Property)this.totalMemory)});
        grid.add(new ComponentState[]{new ComponentState((Component)free, (Property)this.freeMemory)});
        grid.add(new ComponentState[]{new ComponentState((Component)use, (Property)this.memoryUse)});
        if (this.showAllocated) {
            grid.add(new ComponentState[]{new ComponentState((Component)allocatedTotal, (Property)this.allocatedTotalMemory)});
            grid.add(new ComponentState[]{new ComponentState((Component)allocatedFree, (Property)this.allocatedFreeMemory)});
        }
        return grid.createGrid();
    }

    public Property getTotalMemory() {
        return this.totalMemory;
    }

    public Property getFreeMemory() {
        return this.freeMemory;
    }

    public Property getMemoryUse() {
        return this.memoryUse;
    }

    public Property getAllocatedTotal() {
        return this.allocatedTotalMemory;
    }

    public Property getAllocatedFree() {
        return this.allocatedFreeMemory;
    }

    public void refresh() {
        Runtime runtime = Runtime.getRuntime();
        long total = runtime.maxMemory();
        long allocatedTotal = runtime.totalMemory();
        long allocatedFree = runtime.freeMemory();
        long used = allocatedTotal - allocatedFree;
        long free = total - used;
        int percent = total != 0L ? (int)Math.round(100.0 * (double)used / (double)total) : 0;
        this.totalMemory.setValue((Object)NumberFormatter.getSize((long)total));
        this.freeMemory.setValue((Object)NumberFormatter.getSize((long)free));
        this.memoryUse.setValue((Object)(percent + "%"));
        this.allocatedTotalMemory.setValue((Object)NumberFormatter.getSize((long)allocatedTotal));
        this.allocatedFreeMemory.setValue((Object)NumberFormatter.getSize((long)allocatedFree));
    }

    private TextField createField(Property property) {
        TextField field = BoundTextComponentFactory.create((Property)property, (int)10);
        field.setAlignment(Alignment.ALIGN_RIGHT);
        field.setEnabled(false);
        return field;
    }
}

