/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import java.util.ArrayList;
import java.util.List;
import org.ehcache.core.spi.service.StatisticsService;
import org.openvpms.archetype.rules.workflow.CalendarService;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.cache.EhCacheable;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.cache.CacheState;

public class Caches {
    private final List<CacheState> caches = new ArrayList<CacheState>();
    private final StatisticsService statistics = (StatisticsService)ServiceHelper.getBean(StatisticsService.class);
    private static final String APPOINTMENT_CACHE = "appointmentCache";
    private static final String TASK_CACHE = "taskCache";
    private static final String CALENDAR_CACHE = "calendarCache";
    private static final String ROSTER_AREA_CACHE = "rosterAreaCache";
    private static final String ROSTER_USER_CACHE = "rosterUserCache";
    private static final String LOOKUP_CACHE = "lookupCache";
    private static final int SCHEDULE_MULTIPLIER = 60;
    private static final int ROSTER_AREA_MULTIPLIER = 28;
    private static final int ROSTER_USER_MULTIPLIER = 4;
    private static final int LOOKUP_MULTIPLIER = 2;

    public Caches() {
        this.addCache((EhCacheable)ServiceHelper.getAppointmentService(), APPOINTMENT_CACHE, "admin.system.cache.appointment", this.caches);
        this.addCache((EhCacheable)ServiceHelper.getTaskService(), TASK_CACHE, "admin.system.cache.task", this.caches);
        this.addCache((EhCacheable)ServiceHelper.getBean(CalendarService.class), CALENDAR_CACHE, "admin.system.cache.calendar", this.caches);
        RosterService rosterService = (RosterService)ServiceHelper.getBean(RosterService.class);
        this.addCache((EhCacheable)rosterService, ROSTER_AREA_CACHE, "admin.system.cache.rosterarea", this.caches);
        this.addCache(rosterService.getUserCache(), ROSTER_USER_CACHE, "admin.system.cache.rosteruser", this.caches);
        this.addCache((EhCacheable)ServiceHelper.getLookupService(), LOOKUP_CACHE, "admin.system.cache.lookup", this.caches);
    }

    public List<CacheState> getCaches() {
        return this.caches;
    }

    public long getSuggestedSize(CacheState cache) {
        long result = 0L;
        if (APPOINTMENT_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(60, "party.organisationSchedule");
        } else if (TASK_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(60, "party.organisationWorkList");
        } else if (CALENDAR_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(60, "entity.calendarServiceRatio");
        } else if (ROSTER_AREA_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(28, "entity.rosterArea");
        } else if (ROSTER_USER_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(4, "security.user");
        } else if (LOOKUP_CACHE.equals(cache.getName())) {
            result = this.getSuggestedCacheSize(2, "lookup.species", "lookup.breed", "lookup.state", "lookup.suburb", "lookup.diagnosis*", "lookup.visitReason*", "lookup.presentingComplaint*");
        }
        return result;
    }

    private long getSuggestedCacheSize(int factor, String ... archetypes) {
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, true);
        query.setCountResults(true);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        int count = service.get((IArchetypeQuery)query).getTotalResults();
        if (count == 0) {
            count = 1;
        }
        return (long)count * (long)factor;
    }

    private void addCache(EhCacheable cache, String name, String key, List<CacheState> caches) {
        caches.add(new CacheState(cache, name, Messages.get((String)key), this.statistics));
    }
}

