/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system.cache;

import java.util.ArrayList;
import java.util.Iterator;
import org.ehcache.Cache;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.SizeOfFilterSource;
import org.ehcache.sizeof.filters.SizeOfFilter;
import org.openvpms.component.business.service.cache.EhCacheable;
import org.openvpms.web.component.util.ErrorHelper;

public class CacheState {
    private final String name;
    private final String displayName;
    private final EhCacheable cache;
    private final StatisticsService service;
    private CacheStatistics statistics;
    private TierStatistics tierStatistics;
    private long size;

    public CacheState(EhCacheable cache, String name, String displayName, StatisticsService service) {
        this.name = name;
        this.displayName = displayName;
        this.cache = cache;
        this.service = service;
        this.refreshStatistics();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getCount() {
        return this.tierStatistics != null ? this.tierStatistics.getMappings() : 0L;
    }

    public long getMaxCount() {
        CacheRuntimeConfiguration configuration = this.cache.getCache().getRuntimeConfiguration();
        SizedResourcePool pool = (SizedResourcePool)configuration.getResourcePools().getPoolForResource((ResourceType)ResourceType.Core.HEAP);
        return pool != null ? pool.getSize() : 0L;
    }

    public long getHits() {
        return this.statistics != null ? this.statistics.getCacheHits() : 0L;
    }

    public long getMisses() {
        return this.statistics != null ? this.statistics.getCacheMisses() : 0L;
    }

    public long getSize() {
        return this.size;
    }

    public int getUse() {
        long max = this.getMaxCount();
        long count = this.getCount();
        return max != 0L ? (int)Math.round(100.0 * (double)count / (double)max) : 0;
    }

    public void refreshStatistics() {
        this.statistics = this.service.getCacheStatistics(this.name);
        if (this.statistics != null) {
            this.tierStatistics = (TierStatistics)this.statistics.getTierStatistics().get("OnHeap");
        }
        this.size = -1L;
    }

    public void resetStatistics() {
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public void refreshCacheSize() {
        this.size = this.getCount() != 0L ? this.calculateCacheSize() : 0L;
    }

    public void clear() {
        this.cache.clear();
    }

    public Cache getCache() {
        return this.cache.getCache();
    }

    private long calculateCacheSize() {
        long newSize = -1L;
        try {
            Cache cache = this.getCache();
            Iterator iterator = cache.iterator();
            SizeOfFilterSource filters = new SizeOfFilterSource(true);
            SizeOf sizeOf = SizeOf.newInstance((SizeOfFilter[])filters.getFilters());
            ArrayList<Object> values = new ArrayList<Object>();
            while (iterator.hasNext()) {
                Cache.Entry entry = (Cache.Entry)iterator.next();
                values.add(entry.getKey());
                values.add(entry.getValue());
            }
            newSize = sizeOf.deepSizeOf(values.toArray());
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return newSize;
    }
}

