/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.system;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import nextapp.echo2.app.filetransfer.UploadEvent;
import nextapp.echo2.app.filetransfer.UploadListener;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.io.IOUtils;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.plugin.manager.PluginManager;
import org.openvpms.web.component.im.doc.AbstractUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.OptionDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.admin.system.AbstractTabComponent;
import org.openvpms.web.workspace.admin.system.plugin.BundleHelper;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBrowser
extends AbstractTabComponent {
    private final PluginManager manager;
    private final Component component;
    private final Label status = LabelFactory.create((String)"bold");
    private final PagedIMTable<Bundle> plugins = new PagedIMTable((IMTableModel)new PluginTableModel());
    private static final Logger log = LoggerFactory.getLogger(PluginBrowser.class);
    private static final String START_ID = "button.start";
    private static final String STOP_ID = "button.stop";
    private static final String INSTALL_ID = "button.install";
    private static final String UNINSTALL_ID = "button.uninstall";
    private static final String REFRESH_ID = "button.refresh";
    private static final String CONFIGURE_ID = "button.configure";

    public PluginBrowser(HelpContext help) {
        super(help);
        this.plugins.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                PluginBrowser.this.enableButtons();
            }
        });
        this.component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{this.status, this.plugins.getComponent()})});
        this.manager = (PluginManager)ServiceHelper.getBean(PluginManager.class);
        ButtonSet buttons = this.getButtonSet();
        buttons.add(START_ID, this::onStart);
        buttons.add(STOP_ID, this::onStop);
        buttons.add(INSTALL_ID, this::onInstall);
        buttons.add(UNINSTALL_ID, this::onUninstall);
        buttons.add(REFRESH_ID, this::onRefresh);
        buttons.add(CONFIGURE_ID, this::onConfigure);
    }

    public void show() {
        this.refresh();
    }

    public Component getComponent() {
        return SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{this.getButtons(), this.component});
    }

    private void enableButtons() {
        ButtonSet buttons = this.getButtonSet();
        Bundle selected = (Bundle)this.plugins.getSelected();
        boolean started = this.manager.isStarted();
        boolean uninstall = started && selected != null && this.manager.canUninstall(selected);
        boolean restart = started && selected != null && this.manager.canRestart(selected);
        buttons.setEnabled(INSTALL_ID, started);
        buttons.setEnabled(UNINSTALL_ID, uninstall);
        buttons.setEnabled(START_ID, restart);
        buttons.setEnabled(STOP_ID, restart);
        buttons.setEnabled(REFRESH_ID, started);
    }

    private void refresh() {
        Bundle[] bundles;
        int active = 0;
        Bundle selected = (Bundle)this.plugins.getSelected();
        for (Bundle bundle : bundles = this.manager.getBundles()) {
            if (bundle.getState() != 32) continue;
            ++active;
        }
        this.status.setText(Messages.format((String)"admin.system.plugin.active", (Object[])new Object[]{active, bundles.length}));
        int pageSize = 20;
        ListResultSet set = new ListResultSet(Arrays.asList(bundles), pageSize);
        this.plugins.setResultSet((ResultSet)set);
        if (selected != null) {
            for (int i = 0; i < bundles.length; ++i) {
                if (bundles[i].getBundleId() != selected.getBundleId()) continue;
                this.plugins.getModel().setPage(i / pageSize);
                this.plugins.setSelected((Object)bundles[i]);
                break;
            }
        }
        this.enableButtons();
    }

    private void onStart() {
        final Bundle selected = (Bundle)this.plugins.getSelected();
        if (selected != null && selected.getState() != 32 && selected.getBundleId() != 0L) {
            String title = Messages.get((String)"admin.system.plugin.start.title");
            String message = Messages.format((String)"admin.system.plugin.start.message", (Object[])new Object[]{BundleHelper.getName(selected)});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    PluginBrowser.this.start(selected);
                }
            });
        }
        this.refresh();
    }

    private void onRefresh() {
        try {
            this.manager.scanForNewPlugins();
        }
        catch (Exception exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.refresh();
    }

    private void start(Bundle plugin) {
        try {
            this.manager.start(plugin);
        }
        catch (Throwable exception) {
            log.warn("Failed to start bundle=" + BundleHelper.getName(plugin), exception);
            ErrorDialog.show((String)Messages.get((String)"admin.system.plugin.start.title"), (String)Messages.format((String)"admin.system.plugin.start.error", (Object[])new Object[]{BundleHelper.getName(plugin), exception.getMessage()}));
        }
    }

    private void onStop() {
        final Bundle selected = (Bundle)this.plugins.getSelected();
        if (selected != null && selected.getState() != 4 && selected.getBundleId() != 0L) {
            String title = Messages.get((String)"admin.system.plugin.stop.title");
            String message = Messages.format((String)"admin.system.plugin.stop.message", (Object[])new Object[]{BundleHelper.getName(selected)});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    PluginBrowser.this.stop(selected);
                }
            });
        } else {
            this.refresh();
        }
    }

    private void stop(Bundle plugin) {
        try {
            this.manager.stop(plugin);
        }
        catch (Throwable exception) {
            log.warn("Failed to stop bundle=" + BundleHelper.getName(plugin), exception);
            ErrorDialog.show((String)Messages.get((String)"admin.system.plugin.stop.title"), (String)Messages.format((String)"admin.system.plugin.stop.error", (Object[])new Object[]{BundleHelper.getName(plugin), exception.getMessage()}));
        }
        this.refresh();
    }

    private void onInstall() {
        AbstractUploadListener listener = new AbstractUploadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fileUpload(UploadEvent uploadEvent) {
                File file = null;
                File dir = null;
                try {
                    dir = Files.createTempDirectory("openvpmsupload", new FileAttribute[0]).toFile();
                    file = new File(dir, uploadEvent.getFileName());
                    try (FileOutputStream output = new FileOutputStream(file);){
                        IOUtils.copyLarge((InputStream)uploadEvent.getInputStream(), (OutputStream)output);
                    }
                    PluginBrowser.this.manager.install(file);
                }
                catch (Throwable exception) {
                    ErrorHelper.show((Throwable)exception);
                }
                finally {
                    if (file != null) {
                        if (file.delete()) {
                            if (!dir.delete()) {
                                log.warn("Failed to clean up temporary upload dir: " + dir);
                            }
                        } else {
                            log.warn("Failed to clean up temporary upload: " + file);
                        }
                    }
                }
                PluginBrowser.this.refresh();
            }
        };
        UploadDialog dialog = new UploadDialog((UploadListener)listener, this.getHelpContext());
        dialog.show();
    }

    private void onUninstall() {
        final Bundle selected = (Bundle)this.plugins.getSelected();
        if (selected != null && selected.getBundleId() != 0L) {
            String title = Messages.get((String)"admin.system.plugin.uninstall.title");
            String message = Messages.format((String)"admin.system.plugin.uninstall.message", (Object[])new Object[]{BundleHelper.getName(selected)});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    PluginBrowser.this.uninstall(selected);
                }
            });
        } else {
            this.refresh();
        }
    }

    private void uninstall(Bundle plugin) {
        try {
            this.manager.uninstall(plugin);
        }
        catch (Throwable exception) {
            log.warn("Failed to uninstall bundle=" + BundleHelper.getName(plugin), exception);
            ErrorDialog.show((String)Messages.get((String)"admin.system.plugin.uninstall.title"), (String)Messages.format((String)"admin.system.plugin.uninstall.error", (Object[])new Object[]{BundleHelper.getName(plugin), exception.getMessage()}));
        }
        this.refresh();
    }

    private void onConfigure() {
        PracticeService service = (PracticeService)ServiceHelper.getBean(PracticeService.class);
        final Party practice = service.getPractice();
        if (practice != null) {
            final boolean enabled = service.pluginsEnabled();
            final OptionDialog dialog = new OptionDialog(Messages.get((String)"admin.system.plugin.configure.title"), Messages.get((String)"admin.system.plugin.enable.message"), new String[]{Messages.get((String)"admin.system.plugin.enable.yes"), Messages.get((String)"admin.system.plugin.enable.no")});
            dialog.setSelected(enabled ? 0 : 1);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    boolean newEnabled;
                    boolean bl = newEnabled = dialog.getSelected() == 0;
                    if (enabled != newEnabled) {
                        PluginBrowser.this.configure(newEnabled, practice);
                    }
                }
            });
            dialog.show();
        }
    }

    private void configure(boolean enable, Party practice) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)practice);
        bean.setValue("enablePlugins", (Object)enable);
        bean.save();
        this.manager.stop();
        this.manager.start();
        this.refresh();
    }

    private static class PluginTableModel
    extends AbstractIMTableModel<Bundle> {
        private static final int ID_INDEX = 0;
        private static final int NAME_INDEX = 1;
        private static final int VERSION_INDEX = 2;
        private static final int STATUS_INDEX = 3;

        PluginTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(PluginTableModel.createTableColumn((int)0, (String)"admin.system.plugin.id"));
            model.addColumn(PluginTableModel.createTableColumn((int)1, (String)"admin.system.plugin.name"));
            model.addColumn(PluginTableModel.createTableColumn((int)2, (String)"admin.system.plugin.version"));
            model.addColumn(PluginTableModel.createTableColumn((int)3, (String)"admin.system.plugin.status"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Bundle object, TableColumn column, int row) {
            Object result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getBundleId();
                    break;
                }
                case 1: {
                    result = BundleHelper.getName(object);
                    break;
                }
                case 2: {
                    result = object.getVersion().toString();
                    break;
                }
                case 3: {
                    result = BundleHelper.getState(object);
                }
            }
            return result;
        }
    }
}

