/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.sync;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.domain.internal.sync.Change;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;

public class SynchronisationChanges<T extends IMObject>
extends ConfirmationDialog {
    private final List<Change<T>> changes;

    public SynchronisationChanges(String title, List<Change<T>> changes) {
        this(title, Messages.get((String)"admin.sync.message"), changes);
    }

    public SynchronisationChanges(String title, String message, List<Change<T>> changes) {
        super(title, message, OK);
        this.changes = changes;
        this.resize("SynchronisationChangesDialog.size");
    }

    protected void doLayout() {
        Label message = LabelFactory.create();
        message.setText(this.getMessage());
        ListResultSet set = new ListResultSet(this.changes, 20);
        ChangeModel model = new ChangeModel();
        PagedIMTable table = new PagedIMTable(model);
        table.setResultSet((ResultSet)set);
        Grid grid = GridFactory.create((int)1, (Component[])new Component[]{message, TableHelper.createSpacer(), table.getComponent()});
        grid.setWidth(Styles.FULL_WIDTH);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid}));
    }

    private static class ChangeModel<T extends IMObject>
    extends AbstractIMTableModel<Change<T>> {
        private static final int ID_INDEX = 0;
        private static final int NAME_IDEX = 1;
        private static final int STATUS_IDEX = 2;

        ChangeModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(ChangeModel.createTableColumn((int)0, (String)"table.imobject.id"));
            model.addColumn(ChangeModel.createTableColumn((int)1, (String)"table.imobject.name"));
            model.addColumn(ChangeModel.createTableColumn((int)2, (String)"admin.sync.status"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Change<T> object, TableColumn column, int row) {
            Object result = null;
            block0 : switch (column.getModelIndex()) {
                case 0: {
                    result = ((IMObject)object.getObject()).getId();
                    break;
                }
                case 1: {
                    result = ((IMObject)object.getObject()).getName();
                    break;
                }
                case 2: {
                    switch (object.getType()) {
                        case ADDED: {
                            result = Messages.get((String)"admin.sync.added");
                            break block0;
                        }
                        case UPDATED: {
                            result = Messages.get((String)"admin.sync.updated");
                            break block0;
                        }
                        case DEACTIVATED: {
                            result = Messages.get((String)"admin.sync.deactivated");
                        }
                    }
                }
            }
            return result;
        }
    }
}

