/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.style;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.workspace.AbstractWorkspace;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.style.StyleSheets;
import org.openvpms.web.echo.style.UserStyleSheets;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.OpenVPMSApp;
import org.openvpms.web.workspace.admin.style.ChangeResolutionDialog;
import org.openvpms.web.workspace.admin.style.ChangeThemeDialog;
import org.openvpms.web.workspace.admin.style.StyleBrowser;
import org.openvpms.web.workspace.admin.style.StyleEditor;
import org.openvpms.web.workspace.admin.style.StyleHelper;

public class StyleSheetWorkspace
extends AbstractWorkspace<IMObject> {
    private final UserStyleSheets styles;
    private final StyleBrowser browser;

    public StyleSheetWorkspace(Context context) {
        super("admin.stylesheet", context);
        ContextApplicationInstance app = ContextApplicationInstance.getInstance();
        this.styles = app.getStyleSheets();
        this.browser = new StyleBrowser(this.styles, app.getResolution());
    }

    protected Component doLayout() {
        SplitPane root = SplitPaneFactory.create((int)5, (String)"SplitPaneWithButtonRow", (Component[])new Component[0]);
        Component heading = super.doLayout();
        root.add(heading);
        FocusGroup group = new FocusGroup("StyleSheetWorkspace");
        ButtonRow buttons = new ButtonRow(group, "ControlRow", "default");
        buttons.addButton("button.theme", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.changeTheme();
            }
        });
        buttons.addButton("add", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.addResolution();
            }
        });
        buttons.addButton("edit", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.editResolution();
            }
        });
        buttons.addButton("changeResolution", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.changeResolution();
            }
        });
        buttons.addButton("revert", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.revertChanges();
            }
        });
        buttons.addButton("export", (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                StyleSheetWorkspace.this.exportResolution();
            }
        });
        SplitPane content = SplitPaneFactory.create((int)6, (String)"SplitPaneWithButtonRow", (Component[])new Component[]{buttons, this.browser.getComponent()});
        root.add((Component)content);
        return root;
    }

    protected Class<IMObject> getType() {
        return IMObject.class;
    }

    private void changeTheme() {
        ChangeThemeDialog.display();
    }

    private void addResolution() {
        OpenVPMSApp app = OpenVPMSApp.getInstance();
        Map<String, String> properties = StyleHelper.getProperties((StyleSheets)this.styles, this.browser.getSelectedResolution(), false);
        Dimension size = app.getResolution();
        this.editProperties(size, properties, true);
    }

    private void editResolution() {
        Dimension size = this.browser.getSelectedResolution();
        Map<String, String> properties = StyleHelper.getProperties((StyleSheets)this.styles, size, false);
        this.editProperties(size, properties, false);
    }

    private void editProperties(Dimension size, Map<String, String> properties, boolean editSize) {
        if (properties != null) {
            final StyleEditor editor = new StyleEditor(size, properties, this.styles, editSize);
            editor.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    Dimension size = editor.getSize();
                    if (size != null) {
                        OpenVPMSApp app = OpenVPMSApp.getInstance();
                        if (StyleHelper.ANY_RESOLUTION.equals(size)) {
                            StyleSheetWorkspace.this.styles.setDefaultProperties(editor.getProperties());
                        } else {
                            StyleSheetWorkspace.this.styles.setProperties(editor.getProperties(), size.width, size.height);
                        }
                        app.setStyleSheet();
                        StyleSheetWorkspace.this.browser.refresh();
                    }
                }
            });
            editor.show();
        }
    }

    private void changeResolution() {
        ChangeResolutionDialog dialog = new ChangeResolutionDialog(this.styles.getResolutions());
        dialog.show();
    }

    private void revertChanges() {
        ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"stylesheet.revert.title"), Messages.get((String)"stylesheet.revert.message"));
        dialog.show();
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                StyleSheetWorkspace.this.styles.reset();
                StyleSheetWorkspace.this.browser.refresh();
                ContextApplicationInstance.getInstance().setStyleSheet();
            }
        });
    }

    private void exportResolution() {
        Dimension size = this.browser.getSelectedResolution();
        Map<String, String> properties = StyleHelper.getProperties((StyleSheets)this.styles, size, false);
        StringBuilder builder = new StringBuilder();
        if (!StyleHelper.ANY_RESOLUTION.equals(size)) {
            builder.append("# Properties for screen resolution: ").append(size.width).append("x").append(size.height);
            Map defaults = this.styles.getDefaultProperties();
            Iterator<Map.Entry<String, String>> iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String value = (String)defaults.get(entry.getKey());
                if (!Objects.equals(entry.getValue(), value)) continue;
                iter.remove();
            }
        } else {
            builder.append("# Default properties for all screen resolutions");
        }
        builder.append('\n');
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            builder.append(entry.getKey());
            builder.append(" = ");
            builder.append(entry.getValue());
            builder.append('\n');
        }
        InformationDialog.show((String)builder.toString());
    }
}

