/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.style;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.style.StylePropertyEvaluator;
import org.openvpms.web.echo.style.UserStyleSheets;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.admin.style.StyleHelper;

public class StyleEditor
extends PopupDialog {
    private Map<String, String> properties;
    private List<Property> fields = new ArrayList<Property>();
    private final UserStyleSheets styles;
    private SimpleProperty width;
    private SimpleProperty height;
    private Dimension size;
    private final boolean editSize;

    public StyleEditor(Dimension size, Map<String, String> properties, UserStyleSheets styles, boolean editSize) {
        super(Messages.get((String)"stylesheet.edit.title"), "EditDialog", OK_CANCEL);
        this.setModal(true);
        this.size = size;
        this.properties = new LinkedHashMap<String, String>(properties);
        this.editSize = editSize;
        this.styles = styles;
        if (editSize) {
            this.width = new SimpleProperty("width", (Object)size.width, Integer.class);
            this.height = new SimpleProperty("height", (Object)size.height, Integer.class);
            this.width.setValue((Object)size.width);
            this.height.setValue((Object)size.height);
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Dimension getSize() {
        Dimension result = null;
        if (this.editSize) {
            if (this.width.isValid() && this.height.isValid()) {
                result = new Dimension((Integer)this.width.getValue(), (Integer)this.height.getValue());
            }
        } else {
            result = this.size;
        }
        return result;
    }

    protected void doLayout() {
        Grid grid = GridFactory.create((int)2);
        if (this.editSize) {
            StyleHelper.addProperty(grid, (Property)this.width);
            StyleHelper.addProperty(grid, (Property)this.height);
        } else {
            grid.add((Component)LabelFactory.create((String)"stylesheet.resolution"));
            if (StyleHelper.ANY_RESOLUTION.equals(this.size)) {
                grid.add((Component)LabelFactory.create((String)"stylesheet.anyresolution"));
            } else {
                Label label = LabelFactory.create();
                label.setText(Messages.format((String)"stylesheet.size", (Object[])new Object[]{this.size.width, this.size.height}));
                grid.add((Component)label);
            }
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            SimpleProperty property = new SimpleProperty(entry.getKey(), (Object)entry.getValue(), String.class);
            property.setDisplayName(property.getName());
            StyleHelper.addProperty(grid, (Property)property);
            this.fields.add((Property)property);
        }
        this.getLayout().add((Component)grid);
    }

    protected void onOK() {
        Dimension size = this.getSize();
        if (size != null) {
            HashMap<String, String> edited = new HashMap<String, String>();
            for (Property field : this.fields) {
                String value = field.getValue() != null ? field.getValue().toString() : null;
                edited.put(field.getName(), value);
            }
            StylePropertyEvaluator template = new StylePropertyEvaluator(this.styles.getDefaultProperties());
            try {
                Dimension test = size.equals(StyleHelper.ANY_RESOLUTION) ? StyleHelper.DEFAULT_RESOLUTION : size;
                template.getProperties(test.width, test.height, edited);
                this.properties = edited;
                super.onOK();
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        } else {
            ErrorDialog.show((String)Messages.format((String)"stylesheet.invalidresolution", (Object[])new Object[]{this.width.getValue(), this.height.getValue()}));
        }
    }
}

